/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Set;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageProducer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.Closeable;

public abstract class ActiveMQMessageProducerSupport
implements MessageProducer,
Closeable {
    protected ActiveMQSession session;
    protected boolean disableMessageID;
    protected boolean disableMessageTimestamp;
    protected int defaultDeliveryMode;
    protected int defaultPriority;
    protected long defaultTimeToLive;
    protected int sendTimeout = 0;
    public static final Set<String> JMS_PROPERTY_NAMES_DISALLOWED = Set.of("JMSDeliveryMode", "JMSPriority", "JMSMessageID", "JMSTimestamp", "JMSCorrelationID", "JMSType", "NULL", "TRUE", "FALSE", "NOT", "AND", "OR", "BETWEEN", "LIKE", "IN", "IS", "ESCAPE");

    public ActiveMQMessageProducerSupport(ActiveMQSession session) {
        this.session = session;
        this.disableMessageTimestamp = session.connection.isDisableTimeStampsByDefault();
    }

    @Override
    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        throw new UnsupportedOperationException("setDeliveryDelay() is not supported");
    }

    @Override
    public long getDeliveryDelay() throws JMSException {
        throw new UnsupportedOperationException("getDeliveryDelay() is not supported");
    }

    @Override
    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        this.checkClosed();
        this.disableMessageID = disableMessageID;
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    @Override
    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    @Override
    public void setDeliveryMode(int newDeliveryMode) throws JMSException {
        if (newDeliveryMode != 2 && newDeliveryMode != 1) {
            throw new IllegalStateException("unknown delivery mode: " + newDeliveryMode);
        }
        this.checkClosed();
        this.defaultDeliveryMode = newDeliveryMode;
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    @Override
    public void setPriority(int newDefaultPriority) throws JMSException {
        if (newDefaultPriority < 0 || newDefaultPriority > 9) {
            throw new IllegalStateException("default priority must be a value between 0 and 9");
        }
        this.checkClosed();
        this.defaultPriority = newDefaultPriority;
    }

    @Override
    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L) {
            throw new IllegalStateException("cannot set a negative timeToLive");
        }
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    @Override
    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    @Override
    public void send(Message message) throws JMSException {
        this.send(this.getDestination(), message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.getDestination(), message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    protected abstract void checkClosed() throws IllegalStateException;

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public static void validateValidPropertyName(String propertyName) throws IllegalStateRuntimeException {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Invalid JMS property name must not be null or empty");
        }
        if (JMS_PROPERTY_NAMES_DISALLOWED.contains(propertyName)) {
            throw new IllegalArgumentException("Invalid JMS property: " + propertyName + " name is in disallowed list");
        }
        char first = propertyName.charAt(0);
        if (!Character.isJavaIdentifierStart(first)) {
            throw new IllegalArgumentException("Invalid JMS property: " + propertyName + " name starts with invalid character: " + first);
        }
        for (int i2 = 1; i2 < propertyName.length(); ++i2) {
            char c = propertyName.charAt(i2);
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException("Invalid JMS property: " + propertyName + " name contains invalid character: " + c);
        }
    }

    public static void validateValidPropertyValue(String propertyName, Object propertyValue) throws IllegalStateRuntimeException {
        boolean invalid = true;
        if (propertyValue == null || propertyValue instanceof String || propertyValue instanceof Integer || propertyValue instanceof Short || propertyValue instanceof Float || propertyValue instanceof Long || propertyValue instanceof Boolean || propertyValue instanceof Byte || propertyValue instanceof Character || propertyValue instanceof Double) {
            invalid = false;
        }
        if (invalid) {
            throw new MessageFormatRuntimeException("Invalid JMS property: " + propertyName + " value class: " + propertyValue.getClass().getName() + " is not permitted by specification");
        }
    }
}

