/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.PollDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.PollProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.Language;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.StringHelper;

public class PollReifier
extends ProcessorReifier<PollDefinition> {
    public PollReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (PollDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        String uri = ((PollDefinition)this.definition).getEndpointConsumerBuilder() != null ? ((PollDefinition)this.definition).getEndpointConsumerBuilder().getRawUri() : StringHelper.notEmpty((String)((PollDefinition)this.definition).getUri(), (String)"uri", (Object)this);
        Expression exp = this.createExpression(uri);
        long timeout = this.parseDuration(((PollDefinition)this.definition).getTimeout(), 20000L);
        PollProcessor answer = new PollProcessor(exp, uri, timeout);
        answer.setVariableReceive(this.parseString(((PollDefinition)this.definition).getVariableReceive()));
        return answer;
    }

    protected Expression createExpression(String uri) {
        uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.camelContext, (String)uri);
        String language = null;
        if (uri.startsWith("language:")) {
            String value = StringHelper.after((String)uri, (String)"language:");
            language = StringHelper.before((String)value, (String)":");
            uri = StringHelper.after((String)value, (String)":");
        }
        if (language == null) {
            language = LanguageSupport.hasSimpleFunction((String)uri) ? "simple" : "constant";
        }
        Language lan = this.camelContext.resolveLanguage(language);
        return lan.createExpression(uri);
    }
}

