/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.fhir;

import javax.annotation.processing.Generated;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link org.apache.camel.component.fhir.api.FhirLoadPage}.
 */
@ApiParams(apiName = "load-page", 
           description = "API that Loads the previous/next bundle of resources from a paged set, using the link specified in the link type=next tag within the atom bundle",
           apiMethods = {@ApiMethod(methodName = "byUrl", description="Load a page of results using the given URL and bundle type and return a DSTU1 Atom bundle", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle byUrl(String url, Class<org.hl7.fhir.instance.model.api.IBaseBundle> returnType, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName = "next", description="Load the next page of results using the link with relation next in the bundle", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle next(org.hl7.fhir.instance.model.api.IBaseBundle bundle, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName = "previous", description="Load the previous page of results using the link with relation prev in the bundle", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle previous(org.hl7.fhir.instance.model.api.IBaseBundle bundle, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"})}, aliases = {})
@UriParams
@Configurer(extended = true)
@Generated("org.apache.camel.maven.ApiComponentGeneratorMojo")
public final class FhirLoadPageEndpointConfiguration extends FhirConfiguration {
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "next", description="The IBaseBundle"), @ApiMethod(methodName = "previous", description="The IBaseBundle")})
    private org.hl7.fhir.instance.model.api.IBaseBundle bundle;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "byUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName = "next", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName = "previous", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL")})
    private java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "byUrl", description="The return type")})
    private Class<org.hl7.fhir.instance.model.api.IBaseBundle> returnType;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "byUrl", description="The search url")})
    private String url;

    public org.hl7.fhir.instance.model.api.IBaseBundle getBundle() {
        return bundle;
    }

    public void setBundle(org.hl7.fhir.instance.model.api.IBaseBundle bundle) {
        this.bundle = bundle;
    }

    public java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> getExtraParameters() {
        return extraParameters;
    }

    public void setExtraParameters(java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public Class<org.hl7.fhir.instance.model.api.IBaseBundle> getReturnType() {
        return returnType;
    }

    public void setReturnType(Class<org.hl7.fhir.instance.model.api.IBaseBundle> returnType) {
        this.returnType = returnType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
