/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.core.it.routeconfigurations;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;

public class RouteConfigurationsRouteBuilder extends RouteBuilder {

    @Override
    public void configure() {
        from("direct:routeConfigurationWithExplicitId")
                .routeConfigurationId("routeConfigurationWithExplicitId")
                .process(new Processor() {
                    @Override
                    public void process(Exchange exchange) throws RouteConfigurationsException {
                        String body = exchange.getIn().getBody(String.class);
                        if ("explicit-exception".equals(body)) {
                            String message = "Intentional exception to trigger onException in routeConfigurationWithExplicitId";
                            throw new RouteConfigurationsException(message);
                        }
                        exchange.getMessage().setBody("onException has NOT been triggered in routeConfigurationWithExplicitId");
                    }
                });

        from("direct:fallbackRouteConfiguration")
                .process(new Processor() {
                    @Override
                    public void process(Exchange exchange) throws RouteConfigurationsException {
                        String body = exchange.getIn().getBody(String.class);
                        if ("default-exception".equals(body)) {
                            String message = "Intentional exception to trigger onException in fallbackRouteConfiguration";
                            throw new RouteConfigurationsException(message);
                        }
                        exchange.getMessage()
                                .setBody("onException has NOT been triggered in fallbackRouteConfiguration");
                    }
                });
    }

}
