/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.xmp;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.AbstractImagingTest;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;

public abstract class AbstractJpegXmpTest
extends AbstractImagingTest {
    private static final AbstractImagingTest.ImageFilter HAS_JPEG_XMP_IMAGE_FILTER = AbstractJpegXmpTest::hasJpegXmpData;

    protected static List<File> getImagesWithXmpData() throws IOException, ImagingException {
        return AbstractJpegXmpTest.getTestImages(HAS_JPEG_XMP_IMAGE_FILTER);
    }

    protected static boolean hasJpegXmpData(File file) {
        if (!file.getName().toLowerCase().endsWith(".jpg")) {
            return false;
        }
        try {
            ByteSource byteSource = ByteSource.file((File)file);
            return new JpegImageParser().hasXmpSegment(byteSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected List<File> getImagesWithXmpData(int max) throws IOException, ImagingException {
        return AbstractJpegXmpTest.getTestImages(HAS_JPEG_XMP_IMAGE_FILTER, max);
    }

    protected File getImageWithXmpData() throws IOException, ImagingException {
        return this.getTestImage(HAS_JPEG_XMP_IMAGE_FILTER);
    }
}

