/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.scram;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.activemq.artemis.spi.core.security.scram.ScramException;

public class ScramUtils {
    private static final byte[] INT_1 = new byte[]{0, 0, 0, 1};

    private ScramUtils() {
        throw new AssertionError((Object)"non-instantiable utility class");
    }

    public static byte[] generateSaltedPassword(String password, byte[] salt, int iterationsCount, Mac mac) throws ScramException {
        SecretKeySpec key = new SecretKeySpec(password.getBytes(StandardCharsets.US_ASCII), mac.getAlgorithm());
        try {
            mac.init(key);
        }
        catch (InvalidKeyException e) {
            throw new ScramException("Incompatible key", e);
        }
        mac.update(salt);
        mac.update(INT_1);
        byte[] result = mac.doFinal();
        byte[] previous = null;
        for (int i = 1; i < iterationsCount; ++i) {
            mac.update(previous != null ? previous : result);
            previous = mac.doFinal();
            for (int x = 0; x < result.length; ++x) {
                int n = x;
                result[n] = (byte)(result[n] ^ previous[x]);
            }
        }
        return result;
    }

    public static Mac createHmac(byte[] keyBytes, String hmacName) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(hmacName);
        SecretKeySpec key = new SecretKeySpec(keyBytes, hmacName);
        mac.init(key);
        return mac;
    }

    public static byte[] computeHmac(byte[] key, String hmacName, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = ScramUtils.createHmac(key, hmacName);
        mac.update(string.getBytes(StandardCharsets.US_ASCII));
        return mac.doFinal();
    }

    public static byte[] computeHmac(byte[] key, Mac hmac, String string) throws ScramException {
        try {
            hmac.init(new SecretKeySpec(key, hmac.getAlgorithm()));
        }
        catch (InvalidKeyException e) {
            throw new ScramException("invalid key", e);
        }
        hmac.update(string.getBytes(StandardCharsets.US_ASCII));
        return hmac.doFinal();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static NewPasswordByteArrayData newPassword(String passwordClearText, byte[] salt, int iterations, MessageDigest messageDigest, Mac mac) throws ScramException {
        byte[] saltedPassword = ScramUtils.generateSaltedPassword(passwordClearText, salt, iterations, mac);
        byte[] clientKey = ScramUtils.computeHmac(saltedPassword, mac, "Client Key");
        byte[] storedKey = messageDigest.digest(clientKey);
        byte[] serverKey = ScramUtils.computeHmac(saltedPassword, mac, "Server Key");
        return new NewPasswordByteArrayData(saltedPassword, salt, clientKey, storedKey, serverKey, iterations);
    }

    public static NewPasswordStringData byteArrayToStringData(NewPasswordByteArrayData ba) {
        return new NewPasswordStringData(Base64.getEncoder().encodeToString(ba.saltedPassword), Base64.getEncoder().encodeToString(ba.salt), Base64.getEncoder().encodeToString(ba.clientKey), Base64.getEncoder().encodeToString(ba.storedKey), Base64.getEncoder().encodeToString(ba.serverKey), ba.iterations);
    }

    public static class NewPasswordByteArrayData {
        public final byte[] saltedPassword;
        public final byte[] salt;
        public final byte[] clientKey;
        public final byte[] storedKey;
        public final byte[] serverKey;
        public final int iterations;

        public NewPasswordByteArrayData(byte[] saltedPassword, byte[] salt, byte[] clientKey, byte[] storedKey, byte[] serverKey, int iterations) {
            this.saltedPassword = saltedPassword;
            this.salt = salt;
            this.clientKey = clientKey;
            this.storedKey = storedKey;
            this.serverKey = serverKey;
            this.iterations = iterations;
        }
    }

    public static class NewPasswordStringData {
        public final String saltedPassword;
        public final String salt;
        public final String clientKey;
        public final String storedKey;
        public final String serverKey;
        public final int iterations;

        public NewPasswordStringData(String saltedPassword, String salt, String clientKey, String storedKey, String serverKey, int iterations) {
            this.saltedPassword = saltedPassword;
            this.salt = salt;
            this.clientKey = clientKey;
            this.storedKey = storedKey;
            this.serverKey = serverKey;
            this.iterations = iterations;
        }
    }
}

