/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.directory.api.util.Strings;
import org.apache.directory.fortress.core.DelAdminMgr;
import org.apache.directory.fortress.core.Manageable;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.DelAdminMgrImpl;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.rest.DelAdminMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class DelAdminMgrFactory {
    private static final String CLS_NM = DelAdminMgrFactory.class.getName();
    private static final String CREATE_INSTANCE_METHOD = CLS_NM + ".createInstance";

    public static DelAdminMgr createInstance() throws SecurityException {
        return DelAdminMgrFactory.createInstance("HOME");
    }

    public static DelAdminMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CREATE_INSTANCE_METHOD);
        String dAdminClassName = Config.getInstance().getProperty("delegated.adminmgr.implementation");
        Manageable delAdminMgr = Strings.isEmpty((String)dAdminClassName) ? (Config.getInstance().isRestEnabled() ? new DelAdminMgrRestImpl() : new DelAdminMgrImpl()) : (DelAdminMgr)ClassUtil.createInstance(dAdminClassName);
        delAdminMgr.setContextId(contextId);
        return delAdminMgr;
    }

    public static DelAdminMgr createInstance(Session adminSess) throws SecurityException {
        return DelAdminMgrFactory.createInstance("HOME", adminSess);
    }

    public static DelAdminMgr createInstance(String contextId, Session adminSess) throws SecurityException {
        DelAdminMgr delAdminMgr = DelAdminMgrFactory.createInstance(contextId);
        delAdminMgr.setAdmin(adminSess);
        return delAdminMgr;
    }
}

