/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.FilteringSpringBootCondition;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Order(value=0x7FFFFFFF)
class OnBeanCondition
extends FilteringSpringBootCondition
implements ConfigurationCondition {
    OnBeanCondition() {
    }

    @Override
    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    @Override
    protected final ConditionOutcome[] getOutcomes(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        ConditionOutcome[] outcomes = new ConditionOutcome[autoConfigurationClasses.length];
        for (int i2 = 0; i2 < outcomes.length; ++i2) {
            String autoConfigurationClass = autoConfigurationClasses[i2];
            if (autoConfigurationClass == null) continue;
            Set<String> onBeanTypes = autoConfigurationMetadata.getSet(autoConfigurationClass, "ConditionalOnBean");
            outcomes[i2] = this.getOutcome(onBeanTypes, ConditionalOnBean.class);
            if (outcomes[i2] != null) continue;
            Set<String> onSingleCandidateTypes = autoConfigurationMetadata.getSet(autoConfigurationClass, "ConditionalOnSingleCandidate");
            outcomes[i2] = this.getOutcome(onSingleCandidateTypes, ConditionalOnSingleCandidate.class);
        }
        return outcomes;
    }

    private ConditionOutcome getOutcome(Set<String> requiredBeanTypes, Class<? extends Annotation> annotation) {
        List<String> missing = this.filter(requiredBeanTypes, FilteringSpringBootCondition.ClassNameFilter.MISSING, this.getBeanClassLoader());
        if (!missing.isEmpty()) {
            ConditionMessage message = ConditionMessage.forCondition(annotation, new Object[0]).didNotFind("required type", "required types").items(ConditionMessage.Style.QUOTE, missing);
            return ConditionOutcome.noMatch(message);
        }
        return null;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Spec spec;
        ConditionOutcome matchOutcome = ConditionOutcome.match();
        MergedAnnotations annotations = metadata.getAnnotations();
        if (annotations.isPresent(ConditionalOnBean.class) && !(matchOutcome = this.evaluateConditionalOnBean(spec = new Spec(context, metadata, annotations, ConditionalOnBean.class), matchOutcome.getConditionMessage())).isMatch()) {
            return matchOutcome;
        }
        if (metadata.isAnnotated(ConditionalOnSingleCandidate.class.getName()) && !(matchOutcome = this.evaluateConditionalOnSingleCandidate(spec = new SingleCandidateSpec(context, metadata, metadata.getAnnotations()), matchOutcome.getConditionMessage())).isMatch()) {
            return matchOutcome;
        }
        if (metadata.isAnnotated(ConditionalOnMissingBean.class.getName()) && !(matchOutcome = this.evaluateConditionalOnMissingBean(spec = new Spec<ConditionalOnMissingBean>(context, metadata, annotations, ConditionalOnMissingBean.class), matchOutcome.getConditionMessage())).isMatch()) {
            return matchOutcome;
        }
        return matchOutcome;
    }

    private ConditionOutcome evaluateConditionalOnBean(Spec<ConditionalOnBean> spec, ConditionMessage matchMessage) {
        MatchResult matchResult = this.getMatchingBeans(spec);
        if (!matchResult.isAllMatched()) {
            String reason = this.createOnBeanNoMatchReason(matchResult);
            return ConditionOutcome.noMatch(spec.message().because(reason));
        }
        return ConditionOutcome.match(spec.message(matchMessage).found("bean", "beans").items(ConditionMessage.Style.QUOTE, matchResult.getNamesOfAllMatches()));
    }

    private ConditionOutcome evaluateConditionalOnSingleCandidate(Spec<ConditionalOnSingleCandidate> spec, ConditionMessage matchMessage) {
        MatchResult matchResult = this.getMatchingBeans(spec);
        if (!matchResult.isAllMatched()) {
            return ConditionOutcome.noMatch(spec.message().didNotFind("any beans").atAll());
        }
        Set<String> allBeans = matchResult.getNamesOfAllMatches();
        if (allBeans.size() == 1) {
            return ConditionOutcome.match(spec.message(matchMessage).found("a single bean").items(ConditionMessage.Style.QUOTE, allBeans));
        }
        Map<String, BeanDefinition> beanDefinitions = this.getBeanDefinitions(spec.context.getBeanFactory(), allBeans, spec.getStrategy() == SearchStrategy.ALL);
        List<String> primaryBeans = this.getPrimaryBeans(beanDefinitions);
        if (primaryBeans.size() == 1) {
            return ConditionOutcome.match(spec.message(matchMessage).found("a single primary bean '" + primaryBeans.get(0) + "' from beans").items(ConditionMessage.Style.QUOTE, allBeans));
        }
        if (primaryBeans.size() > 1) {
            return ConditionOutcome.noMatch(spec.message().found("multiple primary beans").items(ConditionMessage.Style.QUOTE, primaryBeans));
        }
        List<String> nonFallbackBeans = this.getNonFallbackBeans(beanDefinitions);
        if (nonFallbackBeans.size() == 1) {
            return ConditionOutcome.match(spec.message(matchMessage).found("a single non-fallback bean '" + nonFallbackBeans.get(0) + "' from beans").items(ConditionMessage.Style.QUOTE, allBeans));
        }
        return ConditionOutcome.noMatch(spec.message().found("multiple beans").items(ConditionMessage.Style.QUOTE, allBeans));
    }

    private ConditionOutcome evaluateConditionalOnMissingBean(Spec<ConditionalOnMissingBean> spec, ConditionMessage matchMessage) {
        MatchResult matchResult = this.getMatchingBeans(spec);
        if (matchResult.isAnyMatched()) {
            String reason = this.createOnMissingBeanNoMatchReason(matchResult);
            return ConditionOutcome.noMatch(spec.message().because(reason));
        }
        return ConditionOutcome.match(spec.message(matchMessage).didNotFind("any beans").atAll());
    }

    protected final MatchResult getMatchingBeans(Spec<?> spec) {
        ConfigurableListableBeanFactory beanFactory = this.getSearchBeanFactory(spec);
        ClassLoader classLoader = spec.getContext().getClassLoader();
        boolean considerHierarchy = spec.getStrategy() != SearchStrategy.CURRENT;
        Set<ResolvableType> parameterizedContainers = spec.getParameterizedContainers();
        MatchResult result = new MatchResult();
        Set<String> beansIgnoredByType = this.getNamesOfBeansIgnoredByType(beanFactory, considerHierarchy, spec.getIgnoredTypes(), parameterizedContainers);
        for (ResolvableType type : spec.getTypes()) {
            Map<String, BeanDefinition> typeMatchedDefinitions = this.getBeanDefinitionsForType(beanFactory, considerHierarchy, type, parameterizedContainers);
            Set<String> typeMatchedNames = this.matchedNamesFrom(typeMatchedDefinitions, (name, definition) -> !ScopedProxyUtils.isScopedTarget(name) && this.isCandidate(beanFactory, (String)name, (BeanDefinition)definition, beansIgnoredByType));
            if (typeMatchedNames.isEmpty()) {
                result.recordUnmatchedType(type);
                continue;
            }
            result.recordMatchedType(type, typeMatchedNames);
        }
        for (String annotation : spec.getAnnotations()) {
            Map<String, BeanDefinition> annotationMatchedDefinitions = this.getBeanDefinitionsForAnnotation(classLoader, beanFactory, annotation, considerHierarchy);
            Set<String> annotationMatchedNames = this.matchedNamesFrom(annotationMatchedDefinitions, (name, definition) -> this.isCandidate(beanFactory, (String)name, (BeanDefinition)definition, beansIgnoredByType));
            if (annotationMatchedNames.isEmpty()) {
                result.recordUnmatchedAnnotation(annotation);
                continue;
            }
            result.recordMatchedAnnotation(annotation, annotationMatchedNames);
        }
        for (String beanName : spec.getNames()) {
            if (!beansIgnoredByType.contains(beanName) && this.containsBean(beanFactory, beanName, considerHierarchy)) {
                result.recordMatchedName(beanName);
                continue;
            }
            result.recordUnmatchedName(beanName);
        }
        return result;
    }

    private ConfigurableListableBeanFactory getSearchBeanFactory(Spec<?> spec) {
        ConfigurableListableBeanFactory beanFactory = spec.getContext().getBeanFactory();
        if (spec.getStrategy() == SearchStrategy.ANCESTORS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.state(parent instanceof ConfigurableListableBeanFactory, "Unable to use SearchStrategy.ANCESTORS without ConfigurableListableBeanFactory");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        return beanFactory;
    }

    private Set<String> matchedNamesFrom(Map<String, BeanDefinition> namedDefinitions, BiPredicate<String, BeanDefinition> filter2) {
        LinkedHashSet<String> matchedNames = new LinkedHashSet<String>(namedDefinitions.size());
        for (Map.Entry<String, BeanDefinition> namedDefinition : namedDefinitions.entrySet()) {
            if (!filter2.test(namedDefinition.getKey(), namedDefinition.getValue())) continue;
            matchedNames.add(namedDefinition.getKey());
        }
        return matchedNames;
    }

    private boolean isCandidate(ConfigurableListableBeanFactory beanFactory, String name, BeanDefinition definition, Set<String> ignoredBeans) {
        if (ignoredBeans.contains(name)) {
            return false;
        }
        if (definition == null || definition.isAutowireCandidate() && this.isDefaultCandidate(definition)) {
            return true;
        }
        if (ScopedProxyUtils.isScopedTarget(name)) {
            try {
                BeanDefinition originalDefinition = beanFactory.getBeanDefinition(ScopedProxyUtils.getOriginalBeanName(name));
                if (originalDefinition.isAutowireCandidate() && this.isDefaultCandidate(originalDefinition)) {
                    return true;
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isDefaultCandidate(BeanDefinition definition) {
        if (definition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition abstractBeanDefinition = (AbstractBeanDefinition)definition;
            return abstractBeanDefinition.isDefaultCandidate();
        }
        return true;
    }

    private Set<String> getNamesOfBeansIgnoredByType(ListableBeanFactory beanFactory, boolean considerHierarchy, Set<ResolvableType> ignoredTypes, Set<ResolvableType> parameterizedContainers) {
        Set<String> result = null;
        for (ResolvableType ignoredType : ignoredTypes) {
            Set<String> ignoredNames = this.getBeanDefinitionsForType(beanFactory, considerHierarchy, ignoredType, parameterizedContainers).keySet();
            result = OnBeanCondition.addAll(result, ignoredNames);
        }
        return result != null ? result : Collections.emptySet();
    }

    private Map<String, BeanDefinition> getBeanDefinitionsForType(ListableBeanFactory beanFactory, boolean considerHierarchy, ResolvableType type, Set<ResolvableType> parameterizedContainers) {
        Map<String, BeanDefinition> result = this.collectBeanDefinitionsForType(beanFactory, considerHierarchy, type, parameterizedContainers, null);
        return result != null ? result : Collections.emptyMap();
    }

    private Map<String, BeanDefinition> collectBeanDefinitionsForType(ListableBeanFactory beanFactory, boolean considerHierarchy, ResolvableType type, Set<ResolvableType> parameterizedContainers, Map<String, BeanDefinition> result) {
        HierarchicalBeanFactory hierarchicalBeanFactory;
        BeanFactory parent;
        result = OnBeanCondition.putAll(result, beanFactory.getBeanNamesForType(type, true, false), beanFactory);
        for (ResolvableType parameterizedContainer : parameterizedContainers) {
            ResolvableType generic = ResolvableType.forClassWithGenerics(parameterizedContainer.resolve(), type);
            result = OnBeanCondition.putAll(result, beanFactory.getBeanNamesForType(generic, true, false), beanFactory);
        }
        if (considerHierarchy && beanFactory instanceof HierarchicalBeanFactory && (parent = (hierarchicalBeanFactory = (HierarchicalBeanFactory)((Object)beanFactory)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)parent;
            result = this.collectBeanDefinitionsForType(listableBeanFactory, considerHierarchy, type, parameterizedContainers, result);
        }
        return result;
    }

    private Map<String, BeanDefinition> getBeanDefinitionsForAnnotation(ClassLoader classLoader, ConfigurableListableBeanFactory beanFactory, String type, boolean considerHierarchy) throws LinkageError {
        Map<String, BeanDefinition> result = null;
        try {
            result = this.collectBeanDefinitionsForAnnotation(beanFactory, this.resolveAnnotationType(classLoader, type), considerHierarchy, result);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result != null ? result : Collections.emptyMap();
    }

    private Class<? extends Annotation> resolveAnnotationType(ClassLoader classLoader, String type) throws ClassNotFoundException {
        return OnBeanCondition.resolve(type, classLoader);
    }

    private Map<String, BeanDefinition> collectBeanDefinitionsForAnnotation(ListableBeanFactory beanFactory, Class<? extends Annotation> annotationType, boolean considerHierarchy, Map<String, BeanDefinition> result) {
        BeanFactory parent;
        result = OnBeanCondition.putAll(result, this.getBeanNamesForAnnotation(beanFactory, annotationType), beanFactory);
        if (considerHierarchy && (parent = ((HierarchicalBeanFactory)((Object)beanFactory)).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)parent;
            result = this.collectBeanDefinitionsForAnnotation(listableBeanFactory, annotationType, considerHierarchy, result);
        }
        return result;
    }

    private String[] getBeanNamesForAnnotation(ListableBeanFactory beanFactory, Class<? extends Annotation> annotationType) {
        LinkedHashSet<String> foundBeanNames = new LinkedHashSet<String>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            ConfigurableListableBeanFactory configurableListableBeanFactory;
            BeanDefinition beanDefinition;
            if (beanFactory instanceof ConfigurableListableBeanFactory && (beanDefinition = (configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName)) != null && beanDefinition.isAbstract() || beanFactory.findAnnotationOnBean(beanName, annotationType, false) == null) continue;
            foundBeanNames.add(beanName);
        }
        if (beanFactory instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)((Object)beanFactory);
            for (String beanName : singletonBeanRegistry.getSingletonNames()) {
                if (beanFactory.findAnnotationOnBean(beanName, annotationType) == null) continue;
                foundBeanNames.add(beanName);
            }
        }
        return (String[])foundBeanNames.toArray(String[]::new);
    }

    private boolean containsBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (considerHierarchy) {
            return beanFactory.containsBean(beanName);
        }
        return beanFactory.containsLocalBean(beanName);
    }

    private String createOnBeanNoMatchReason(MatchResult matchResult) {
        StringBuilder reason = new StringBuilder();
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedAnnotations(), "annotated with");
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedTypes(), "of type");
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedNames(), "named");
        return reason.toString();
    }

    private void appendMessageForNoMatches(StringBuilder reason, Collection<String> unmatched, String description) {
        if (!unmatched.isEmpty()) {
            if (!reason.isEmpty()) {
                reason.append(" and ");
            }
            reason.append("did not find any beans ");
            reason.append(description);
            reason.append(" ");
            reason.append(StringUtils.collectionToDelimitedString(unmatched, ", "));
        }
    }

    private String createOnMissingBeanNoMatchReason(MatchResult matchResult) {
        StringBuilder reason = new StringBuilder();
        this.appendMessageForMatches(reason, matchResult.getMatchedAnnotations(), "annotated with");
        this.appendMessageForMatches(reason, matchResult.getMatchedTypes(), "of type");
        if (!matchResult.getMatchedNames().isEmpty()) {
            if (!reason.isEmpty()) {
                reason.append(" and ");
            }
            reason.append("found beans named ");
            reason.append(StringUtils.collectionToDelimitedString(matchResult.getMatchedNames(), ", "));
        }
        return reason.toString();
    }

    private void appendMessageForMatches(StringBuilder reason, Map<String, Collection<String>> matches, String description) {
        if (!matches.isEmpty()) {
            matches.forEach((key, value) -> {
                if (!reason.isEmpty()) {
                    reason.append(" and ");
                }
                reason.append("found beans ");
                reason.append(description);
                reason.append(" '");
                reason.append((String)key);
                reason.append("' ");
                reason.append(StringUtils.collectionToDelimitedString(value, ", "));
            });
        }
    }

    private Map<String, BeanDefinition> getBeanDefinitions(ConfigurableListableBeanFactory beanFactory, Set<String> beanNames, boolean considerHierarchy) {
        HashMap<String, BeanDefinition> definitions = new HashMap<String, BeanDefinition>(beanNames.size());
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = this.findBeanDefinition(beanFactory, beanName, considerHierarchy);
            definitions.put(beanName, beanDefinition);
        }
        return definitions;
    }

    private List<String> getPrimaryBeans(Map<String, BeanDefinition> beanDefinitions) {
        return this.getMatchingBeans(beanDefinitions, BeanDefinition::isPrimary);
    }

    private List<String> getNonFallbackBeans(Map<String, BeanDefinition> beanDefinitions) {
        return this.getMatchingBeans(beanDefinitions, Predicate.not(BeanDefinition::isFallback));
    }

    private List<String> getMatchingBeans(Map<String, BeanDefinition> beanDefinitions, Predicate<BeanDefinition> test) {
        ArrayList<String> matches = new ArrayList<String>();
        for (Map.Entry<String, BeanDefinition> namedBeanDefinition : beanDefinitions.entrySet()) {
            if (!test.test(namedBeanDefinition.getValue())) continue;
            matches.add(namedBeanDefinition.getKey());
        }
        return matches;
    }

    private BeanDefinition findBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        BeanFactory beanFactory2;
        if (beanFactory.containsBeanDefinition(beanName)) {
            return beanFactory.getBeanDefinition(beanName);
        }
        if (considerHierarchy && (beanFactory2 = beanFactory.getParentBeanFactory()) instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory listableBeanFactory = (ConfigurableListableBeanFactory)beanFactory2;
            return this.findBeanDefinition(listableBeanFactory, beanName, considerHierarchy);
        }
        return null;
    }

    private static Set<String> addAll(Set<String> result, Collection<String> additional) {
        if (CollectionUtils.isEmpty(additional)) {
            return result;
        }
        result = result != null ? result : new LinkedHashSet<String>();
        result.addAll(additional);
        return result;
    }

    private static Map<String, BeanDefinition> putAll(Map<String, BeanDefinition> result, String[] beanNames, ListableBeanFactory beanFactory) {
        if (ObjectUtils.isEmpty(beanNames)) {
            return result;
        }
        if (result == null) {
            result = new LinkedHashMap<String, BeanDefinition>();
        }
        for (String beanName : beanNames) {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)beanFactory;
                result.put(beanName, OnBeanCondition.getBeanDefinition(beanName, clbf));
                continue;
            }
            result.put(beanName, null);
        }
        return result;
    }

    private static BeanDefinition getBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (BeanFactoryUtils.isFactoryDereference(beanName)) {
                return OnBeanCondition.getBeanDefinition(BeanFactoryUtils.transformedBeanName(beanName), beanFactory);
            }
            return null;
        }
    }

    private static class Spec<A extends Annotation> {
        private final ConditionContext context;
        private final Class<? extends Annotation> annotationType;
        private final Set<String> names;
        private final Set<ResolvableType> types;
        private final Set<String> annotations;
        private final Set<ResolvableType> ignoredTypes;
        private final Set<ResolvableType> parameterizedContainers;
        private final SearchStrategy strategy;

        Spec(ConditionContext context, AnnotatedTypeMetadata metadata, MergedAnnotations annotations, Class<A> annotationType) {
            MultiValueMap<String, Object> attributes = annotations.stream(annotationType).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).collect(MergedAnnotationCollectors.toMultiValueMap(MergedAnnotation.Adapt.CLASS_TO_STRING));
            MergedAnnotation<A> annotation = annotations.get(annotationType);
            this.context = context;
            this.annotationType = annotationType;
            this.names = this.extract(attributes, "name");
            this.annotations = this.extract(attributes, "annotation");
            this.ignoredTypes = this.resolveWhenPossible(this.extract(attributes, "ignored", "ignoredType"));
            this.parameterizedContainers = this.resolveWhenPossible(this.extract(attributes, "parameterizedContainer"));
            this.strategy = annotation.getValue("search", SearchStrategy.class).orElse(null);
            Set<ResolvableType> types = this.resolveWhenPossible(this.extractTypes(attributes));
            BeanTypeDeductionException deductionException = null;
            if (types.isEmpty() && this.names.isEmpty() && this.annotations.isEmpty()) {
                try {
                    types = this.deducedBeanType(context, metadata);
                }
                catch (BeanTypeDeductionException ex) {
                    deductionException = ex;
                }
            }
            this.types = types;
            this.validate(deductionException);
        }

        protected Set<String> extractTypes(MultiValueMap<String, Object> attributes) {
            return this.extract(attributes, "value", "type");
        }

        private Set<String> extract(MultiValueMap<String, Object> attributes, String ... attributeNames) {
            if (attributes.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String attributeName : attributeNames) {
                List values = attributes.getOrDefault(attributeName, Collections.emptyList());
                for (Object value : values) {
                    if (value instanceof String[]) {
                        String[] stringArray = (String[])value;
                        this.merge(result, stringArray);
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    String string = (String)value;
                    this.merge(result, string);
                }
            }
            return result.isEmpty() ? Collections.emptySet() : result;
        }

        private void merge(Set<String> result, String ... additional) {
            Collections.addAll(result, additional);
        }

        private Set<ResolvableType> resolveWhenPossible(Set<String> classNames) {
            if (classNames.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet<ResolvableType> resolved = new LinkedHashSet<ResolvableType>(classNames.size());
            for (String className : classNames) {
                try {
                    Class<?> type = FilteringSpringBootCondition.resolve(className, this.context.getClassLoader());
                    resolved.add(ResolvableType.forRawClass(type));
                }
                catch (ClassNotFoundException | NoClassDefFoundError ex) {
                    resolved.add(ResolvableType.NONE);
                }
            }
            return resolved;
        }

        protected void validate(BeanTypeDeductionException ex) {
            if (!this.hasAtLeastOneElement(this.getTypes(), this.getNames(), this.getAnnotations())) {
                String message = this.getAnnotationName() + " did not specify a bean using type, name or annotation";
                if (ex == null) {
                    throw new IllegalStateException(message);
                }
                throw new IllegalStateException(message + " and the attempt to deduce the bean's type failed", ex);
            }
        }

        private boolean hasAtLeastOneElement(Set<?> ... sets) {
            for (Set<?> set : sets) {
                if (set.isEmpty()) continue;
                return true;
            }
            return false;
        }

        protected final String getAnnotationName() {
            return "@" + ClassUtils.getShortName(this.annotationType);
        }

        private Set<ResolvableType> deducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                return this.deducedBeanTypeForBeanMethod(context, (MethodMetadata)metadata);
            }
            return Collections.emptySet();
        }

        private Set<ResolvableType> deducedBeanTypeForBeanMethod(ConditionContext context, MethodMetadata metadata) {
            try {
                return Set.of(this.getReturnType(context, metadata));
            }
            catch (Throwable ex) {
                throw new BeanTypeDeductionException(metadata.getDeclaringClassName(), metadata.getMethodName(), ex);
            }
        }

        private ResolvableType getReturnType(ConditionContext context, MethodMetadata metadata) throws ClassNotFoundException, LinkageError {
            ClassLoader classLoader = context.getClassLoader();
            ResolvableType returnType = this.getMethodReturnType(metadata, classLoader);
            if (this.isParameterizedContainer(returnType.resolve())) {
                returnType = returnType.getGeneric(new int[0]);
            }
            return returnType;
        }

        private boolean isParameterizedContainer(Class<?> type) {
            return type != null && this.parameterizedContainers.stream().map(ResolvableType::resolve).anyMatch(container -> container != null && container.isAssignableFrom(type));
        }

        private ResolvableType getMethodReturnType(MethodMetadata metadata, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
            Class<?> declaringClass = FilteringSpringBootCondition.resolve(metadata.getDeclaringClassName(), classLoader);
            Method beanMethod = this.findBeanMethod(declaringClass, metadata.getMethodName());
            return ResolvableType.forMethodReturnType(beanMethod);
        }

        private Method findBeanMethod(Class<?> declaringClass, String methodName) {
            Method[] candidates;
            Method method = ReflectionUtils.findMethod(declaringClass, methodName);
            if (this.isBeanMethod(method)) {
                return method;
            }
            for (Method candidate : candidates = ReflectionUtils.getAllDeclaredMethods(declaringClass)) {
                if (!candidate.getName().equals(methodName) || !this.isBeanMethod(candidate)) continue;
                return candidate;
            }
            throw new IllegalStateException("Unable to find bean method " + methodName);
        }

        private boolean isBeanMethod(Method method) {
            return method != null && MergedAnnotations.from(method, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Bean.class);
        }

        private SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        Set<ResolvableType> getTypes() {
            return this.types;
        }

        private ConditionContext getContext() {
            return this.context;
        }

        private Set<String> getNames() {
            return this.names;
        }

        private Set<String> getAnnotations() {
            return this.annotations;
        }

        private Set<ResolvableType> getIgnoredTypes() {
            return this.ignoredTypes;
        }

        private Set<ResolvableType> getParameterizedContainers() {
            return this.parameterizedContainers;
        }

        private ConditionMessage.Builder message() {
            return ConditionMessage.forCondition(this.annotationType, this);
        }

        private ConditionMessage.Builder message(ConditionMessage message) {
            return message.andCondition(this.annotationType, this);
        }

        public String toString() {
            boolean hasNames = !this.names.isEmpty();
            boolean hasTypes = !this.types.isEmpty();
            boolean hasIgnoredTypes = !this.ignoredTypes.isEmpty();
            StringBuilder string = new StringBuilder();
            string.append("(");
            if (hasNames) {
                string.append("names: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.names));
                string.append(hasTypes ? " " : "; ");
            }
            if (hasTypes) {
                string.append("types: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.types));
                string.append(hasIgnoredTypes ? " " : "; ");
            }
            if (hasIgnoredTypes) {
                string.append("ignored: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.ignoredTypes));
                string.append("; ");
            }
            string.append("SearchStrategy: ");
            string.append(this.strategy.toString().toLowerCase(Locale.ENGLISH));
            string.append(")");
            return string.toString();
        }
    }

    private static class SingleCandidateSpec
    extends Spec<ConditionalOnSingleCandidate> {
        private static final Collection<String> FILTERED_TYPES = Arrays.asList("", Object.class.getName());

        SingleCandidateSpec(ConditionContext context, AnnotatedTypeMetadata metadata, MergedAnnotations annotations) {
            super(context, metadata, annotations, ConditionalOnSingleCandidate.class);
        }

        @Override
        protected Set<String> extractTypes(MultiValueMap<String, Object> attributes) {
            Set<String> types = super.extractTypes(attributes);
            types.removeAll(FILTERED_TYPES);
            return types;
        }

        @Override
        protected void validate(BeanTypeDeductionException ex) {
            Assert.isTrue(this.getTypes().size() == 1, () -> this.getAnnotationName() + " annotations must specify only one type (got " + StringUtils.collectionToCommaDelimitedString(this.getTypes()) + ")");
        }
    }

    private static final class MatchResult {
        private final Map<String, Collection<String>> matchedAnnotations = new HashMap<String, Collection<String>>();
        private final List<String> matchedNames = new ArrayList<String>();
        private final Map<String, Collection<String>> matchedTypes = new HashMap<String, Collection<String>>();
        private final List<String> unmatchedAnnotations = new ArrayList<String>();
        private final List<String> unmatchedNames = new ArrayList<String>();
        private final List<String> unmatchedTypes = new ArrayList<String>();
        private final Set<String> namesOfAllMatches = new HashSet<String>();

        private MatchResult() {
        }

        private void recordMatchedName(String name) {
            this.matchedNames.add(name);
            this.namesOfAllMatches.add(name);
        }

        private void recordUnmatchedName(String name) {
            this.unmatchedNames.add(name);
        }

        private void recordMatchedAnnotation(String annotation, Collection<String> matchingNames) {
            this.matchedAnnotations.put(annotation, matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedAnnotation(String annotation) {
            this.unmatchedAnnotations.add(annotation);
        }

        private void recordMatchedType(ResolvableType type, Collection<String> matchingNames) {
            this.matchedTypes.put(type.toString(), matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedType(ResolvableType type) {
            this.unmatchedTypes.add(type.toString());
        }

        boolean isAllMatched() {
            return this.unmatchedAnnotations.isEmpty() && this.unmatchedNames.isEmpty() && this.unmatchedTypes.isEmpty();
        }

        boolean isAnyMatched() {
            return !this.matchedAnnotations.isEmpty() || !this.matchedNames.isEmpty() || !this.matchedTypes.isEmpty();
        }

        Map<String, Collection<String>> getMatchedAnnotations() {
            return this.matchedAnnotations;
        }

        List<String> getMatchedNames() {
            return this.matchedNames;
        }

        Map<String, Collection<String>> getMatchedTypes() {
            return this.matchedTypes;
        }

        List<String> getUnmatchedAnnotations() {
            return this.unmatchedAnnotations;
        }

        List<String> getUnmatchedNames() {
            return this.unmatchedNames;
        }

        List<String> getUnmatchedTypes() {
            return this.unmatchedTypes;
        }

        Set<String> getNamesOfAllMatches() {
            return this.namesOfAllMatches;
        }
    }

    static final class BeanTypeDeductionException
    extends RuntimeException {
        private BeanTypeDeductionException(String className, String beanMethodName, Throwable cause) {
            super("Failed to deduce bean type for " + className + "." + beanMethodName, cause);
        }
    }
}

