/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.websocket;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.websocket.WebSocketMessageEncoder;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Internal
public class NettyWebSocketSession
implements WebSocketSession {
    public static final AttributeKey<NettyWebSocketSession> WEB_SOCKET_SESSION_KEY = AttributeKey.newInstance("micronaut.websocket.session");
    private final String id;
    private final Channel channel;
    private final HttpRequest<?> request;
    private final String protocolVersion;
    private final boolean isSecure;
    private final MediaTypeCodecRegistry codecRegistry;
    private final MutableConvertibleValues<Object> attributes;
    private final WebSocketMessageEncoder messageEncoder;

    protected NettyWebSocketSession(String id, Channel channel, HttpRequest<?> request, MediaTypeCodecRegistry codecRegistry, String protocolVersion, boolean isSecure) {
        this.id = id;
        this.channel = channel;
        this.request = request;
        this.protocolVersion = protocolVersion;
        this.isSecure = isSecure;
        this.channel.attr(WEB_SOCKET_SESSION_KEY).set(this);
        this.codecRegistry = codecRegistry;
        this.messageEncoder = new WebSocketMessageEncoder(this.codecRegistry);
        this.attributes = request.getAttribute("micronaut.SESSION", MutableConvertibleValues.class).orElseGet(MutableConvertibleValuesMap::new);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen() && this.channel.isActive();
    }

    @Override
    public boolean isWritable() {
        return this.channel.isWritable();
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public Set<? extends WebSocketSession> getOpenSessions() {
        return Collections.emptySet();
    }

    @Override
    public URI getRequestURI() {
        return this.request.getUri();
    }

    @Override
    public ConvertibleMultiValues<String> getRequestParameters() {
        return this.request.getParameters();
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public <T> CompletableFuture<T> sendAsync(T message, MediaType mediaType) {
        if (this.isOpen()) {
            if (message != null) {
                CompletableFuture future = new CompletableFuture();
                WebSocketFrame frame = message instanceof WebSocketFrame ? (WebSocketFrame)message : this.messageEncoder.encodeMessage(message, mediaType);
                this.channel.writeAndFlush(frame).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                    if (f.isSuccess()) {
                        future.complete(message);
                    } else {
                        future.completeExceptionally(new WebSocketSessionException("Send Failure: " + f.cause().getMessage(), f.cause()));
                    }
                }));
                return future;
            }
            return CompletableFuture.completedFuture(null);
        }
        throw new WebSocketSessionException("Session closed");
    }

    @Override
    public void sendSync(Object message, MediaType mediaType) {
        if (this.isOpen()) {
            if (message != null) {
                try {
                    WebSocketFrame frame = message instanceof WebSocketFrame ? (WebSocketFrame)message : this.messageEncoder.encodeMessage(message, mediaType);
                    this.channel.writeAndFlush(frame).sync().get();
                }
                catch (InterruptedException e) {
                    throw new WebSocketSessionException("Send interrupt: " + e.getMessage(), e);
                }
                catch (ExecutionException e) {
                    throw new WebSocketSessionException("Send Failure: " + e.getMessage(), e);
                }
            }
        } else {
            throw new WebSocketSessionException("Session closed");
        }
    }

    public <T> Flux<T> send(T message, MediaType mediaType) {
        if (message == null) {
            return Flux.empty();
        }
        return Flux.create(emitter -> {
            if (!this.isOpen()) {
                emitter.error(new WebSocketSessionException("Session closed"));
            } else {
                WebSocketFrame frame = message instanceof WebSocketFrame ? (WebSocketFrame)message : this.messageEncoder.encodeMessage(message, mediaType);
                ChannelFuture channelFuture = this.channel.writeAndFlush(frame);
                channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                    if (future.isSuccess()) {
                        emitter.next(message);
                        emitter.complete();
                    } else {
                        emitter.error(new WebSocketSessionException("Send Failure: " + future.cause().getMessage(), future.cause()));
                    }
                }));
            }
        }, FluxSink.OverflowStrategy.ERROR);
    }

    @Override
    @NonNull
    public CompletableFuture<?> sendPingAsync(@NonNull byte[] content) {
        if (this.isOpen()) {
            ByteBuf messageBuffer = this.channel.alloc().buffer(content.length);
            messageBuffer.writeBytes(content);
            PingWebSocketFrame frame = new PingWebSocketFrame(messageBuffer);
            CompletableFuture future = new CompletableFuture();
            this.channel.writeAndFlush(frame).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                if (f.isSuccess()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(new WebSocketSessionException("Send Failure: " + f.cause().getMessage(), f.cause()));
                }
            }));
            return future;
        }
        throw new WebSocketSessionException("Session closed");
    }

    @Override
    public void close() {
        this.close(CloseReason.NORMAL);
    }

    @Override
    public void close(CloseReason closeReason) {
        if (this.channel.isOpen()) {
            this.channel.writeAndFlush(new CloseWebSocketFrame(closeReason.getCode(), closeReason.getReason())).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.channel.close()));
        }
    }

    public String toString() {
        return "WebSocket Session: " + this.getId();
    }

    @Override
    public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public MutableConvertibleValues<Object> remove(CharSequence key) {
        return this.attributes.remove(key);
    }

    @Override
    public MutableConvertibleValues<Object> clear() {
        return this.attributes.clear();
    }

    @Override
    public Set<String> names() {
        return this.attributes.names();
    }

    @Override
    public Collection<Object> values() {
        return this.attributes.values();
    }

    @Override
    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.attributes.get(name, conversionContext);
    }
}

