/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler.tags;

import grails.util.GrailsStringUtils;
import org.grails.gsp.compiler.tags.GroovySyntaxTag;
import org.grails.taglib.GrailsTagException;

abstract class GroovyConditionalTag
extends GroovySyntaxTag {
    static final String ATTRIBUTE_TEST = "test";
    static final String ATTRIBUTE_ENV = "env";

    GroovyConditionalTag() {
    }

    @Override
    public void doStartTag() {
        String env = this.attributeValueOrNull(ATTRIBUTE_ENV);
        String test = this.attributeValueOrNull(ATTRIBUTE_TEST);
        if (env == null && test == null) {
            throw new GrailsTagException("Tag [" + this.getName() + "] must have one or both of the attributes [test] or [env]", this.parser.getPageName(), this.parser.getCurrentOutputLineNumber());
        }
        String envExpression = this.environmentExpressionOrTrue(env);
        String testExpression = this.testExpressionOrTrue(test);
        this.outputStartTag(envExpression, testExpression);
    }

    protected abstract void outputStartTag(String var1, String var2);

    @Override
    public void doEndTag() {
        this.out.println("}");
    }

    protected String attributeValueOrNull(String attributeName) {
        String attributeValue = (String)this.attributes.get(attributeName);
        return GrailsStringUtils.isBlank(attributeValue) ? null : attributeValue;
    }

    private String environmentExpressionOrTrue(String envAttributeValue) {
        Object expression = "true";
        if (envAttributeValue != null) {
            expression = "(grails.util.Environment.current.name == '" + this.calculateExpression(envAttributeValue) + "')";
        }
        return expression;
    }

    private String testExpressionOrTrue(String testAttributeValue) {
        Object expression = "true";
        if (testAttributeValue != null) {
            expression = "(" + testAttributeValue + ")";
        }
        return expression;
    }

    @Override
    public boolean isKeepPrecedingWhiteSpace() {
        return true;
    }

    @Override
    public boolean isAllowPrecedingContent() {
        return true;
    }
}

