/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.tracing;

import io.opentelemetry.api.trace.Span;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.ext.Provider;
import org.apache.polaris.core.context.RealmContext;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@PreMatching
@ApplicationScoped
@Priority(value=902)
@Provider
public class TracingFilter
implements ContainerRequestFilter {
    public static final String REQUEST_ID_ATTRIBUTE = "polaris.request.id";
    public static final String REALM_ID_ATTRIBUTE = "polaris.realm.id";
    @ConfigProperty(name="quarkus.otel.sdk.disabled")
    boolean sdkDisabled;

    public void filter(ContainerRequestContext rc) {
        if (!this.sdkDisabled) {
            Span span = Span.current();
            String requestId = (String)rc.getProperty("requestId");
            if (requestId != null) {
                span.setAttribute(REQUEST_ID_ATTRIBUTE, requestId);
            }
            RealmContext realmContext = (RealmContext)rc.getProperty("realmContext");
            span.setAttribute(REALM_ID_ATTRIBUTE, realmContext.getRealmIdentifier());
        }
    }
}

