/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.tagvalue;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.james.jdkim.api.HashMethod;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.api.SigningAlgorithm;
import org.apache.james.jdkim.codec.binary.Base64;
import org.apache.james.jdkim.parser.DKIMQuotedPrintable;
import org.apache.james.jdkim.tagvalue.SignatureRecordImpl;
import org.apache.james.jdkim.tagvalue.TagValue;

public class SignatureRecordTemplate
extends TagValue
implements SignatureRecord {
    private static final Pattern hdrNamePattern = Pattern.compile("^[^: \r\n\t]+$");

    public SignatureRecordTemplate(String data) {
        super(data);
        this.validate();
        Set<String> tags = this.getTags();
        this.defaults.forEach((key, value) -> {
            if (!tags.contains(key) && !"l".equals(key)) {
                this.setValue((String)key, value.toString());
            }
        });
    }

    @Override
    protected void init() {
        this.mandatoryTags.add("v");
        this.mandatoryTags.add("d");
        this.mandatoryTags.add("h");
        this.mandatoryTags.add("s");
        this.defaults.put("b", "");
        this.defaults.put("bh", "");
        this.defaults.put("c", "simple/simple");
        this.defaults.put("l", ";all;");
        this.defaults.put("q", "dns/txt");
    }

    @Override
    public void validate() throws IllegalStateException {
        long expiration;
        long lifetime;
        CharSequence identity;
        super.validate();
        if (!"1".equals(this.getValue("v"))) {
            throw new IllegalStateException("Invalid DKIM-Signature version (expected '1'): " + this.getValue("v"));
        }
        if (this.getValue("h").length() == 0) {
            throw new IllegalStateException("Tag h= cannot be empty.");
        }
        try {
            identity = this.getIdentity();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Identity (i=) declaration cannot be parsed. Probably due to missing quoted printable encoding", e);
        }
        if (!identity.toString().toLowerCase().endsWith(("@" + this.getValue("d")).toLowerCase()) && !this.getIdentity().toString().toLowerCase().endsWith(("." + this.getValue("d")).toLowerCase())) {
            throw new IllegalStateException("Identity (i=) domain mismatch: expected [optional]@[optional.]domain-from-d-attribute");
        }
        if (this.getValue("x") != null && (lifetime = (expiration = Long.parseLong(this.getValue("x").toString())) - System.currentTimeMillis() / 1000L) < 0L) {
            throw new IllegalStateException("Signature is expired since " + this.getTimeMeasure(lifetime) + ".");
        }
        if (!this.isInListCaseInsensitive("from", this.getHeaders())) {
            throw new IllegalStateException("From field not signed");
        }
    }

    private String getTimeMeasure(long lifetime) {
        String measure = "s";
        if ((lifetime = -lifetime) > 600L) {
            measure = "m";
            if ((lifetime /= 60L) > 600L) {
                measure = "h";
                if ((lifetime /= 60L) > 120L) {
                    measure = "d";
                    if ((lifetime /= 24L) > 90L) {
                        measure = " months";
                        if ((lifetime /= 30L) > 24L) {
                            lifetime /= 12L;
                            measure = " years";
                        }
                    }
                }
            }
        }
        return lifetime + measure;
    }

    @Override
    public List<CharSequence> getHeaders() {
        return this.stringToColonSeparatedList(this.getValue("h").toString(), hdrNamePattern);
    }

    @Override
    protected CharSequence getDefault(String tag) {
        if ("i".equals(tag)) {
            return "@" + this.getValue("d");
        }
        return super.getDefault(tag);
    }

    @Override
    public CharSequence getIdentityLocalPart() {
        String identity = this.getIdentity().toString();
        int pAt = identity.indexOf(64);
        return identity.subSequence(0, pAt);
    }

    @Override
    public CharSequence getIdentity() {
        return DKIMQuotedPrintable.dkimQuotedPrintableDecode(this.getValue("i"));
    }

    @Override
    public CharSequence getHashKeyType() {
        String a = this.getValue("a").toString();
        int pHyphen = a.indexOf(45);
        if (pHyphen == -1) {
            throw new IllegalStateException("Invalid hash algorythm (key type): " + a);
        }
        return a.subSequence(0, pHyphen);
    }

    @Override
    public CharSequence getHashMethod() {
        String a = this.getValue("a").toString();
        int pHyphen = a.indexOf(45);
        if (pHyphen == -1) {
            throw new IllegalStateException("Invalid hash method: " + a);
        }
        return a.subSequence(pHyphen + 1, a.length());
    }

    @Override
    public CharSequence getHashAlgo() {
        String a = this.getValue("a").toString();
        int pHyphen = a.indexOf(45);
        if (pHyphen == -1) {
            throw new IllegalStateException("Invalid hash method: " + a);
        }
        if (a.length() > pHyphen + 3 && a.charAt(pHyphen + 1) == 's' && a.charAt(pHyphen + 2) == 'h' && a.charAt(pHyphen + 3) == 'a') {
            return "sha-" + a.subSequence(pHyphen + 4, a.length());
        }
        return a.subSequence(pHyphen + 1, a.length());
    }

    @Override
    public CharSequence getSelector() {
        return this.getValue("s");
    }

    @Override
    public CharSequence getDToken() {
        return this.getValue("d");
    }

    @Override
    public byte[] getBodyHash() {
        return Base64.decodeBase64(this.getValue("bh").toString().getBytes());
    }

    @Override
    public byte[] getSignature() {
        return Base64.decodeBase64(this.getValue("b").toString().getBytes());
    }

    @Override
    public CharSequence getRawSignature() {
        return this.getValue("b");
    }

    @Override
    public int getBodyHashLimit() {
        String limit = this.getValue("l").toString();
        if (";all;".equals(limit)) {
            return -1;
        }
        return Integer.parseInt(limit);
    }

    @Override
    public Long getSignatureTimestamp() {
        CharSequence cs = this.getValue("t");
        if (cs == null) {
            return null;
        }
        return Long.parseLong(cs.toString());
    }

    @Override
    public String getBodyCanonicalisationMethod() {
        String c = this.getValue("c").toString();
        int pSlash = c.indexOf("/");
        if (pSlash != -1) {
            return c.substring(pSlash + 1);
        }
        return "simple";
    }

    @Override
    public String getHeaderCanonicalisationMethod() {
        String c = this.getValue("c").toString();
        int pSlash = c.indexOf("/");
        if (pSlash != -1) {
            return c.substring(0, pSlash);
        }
        return c;
    }

    @Override
    public List<CharSequence> getRecordLookupMethods() {
        String flags = this.getValue("q").toString();
        String[] flagsStrings = flags.split(":");
        LinkedList<CharSequence> res = new LinkedList<CharSequence>();
        for (String flagsString : flagsStrings) {
            res.add(this.trimFWS(flagsString, 0, flagsString.length() - 1, true));
        }
        return res;
    }

    @Override
    public void setSignature(byte[] newSignature) {
        String signature = new String(Base64.encodeBase64(newSignature));
        this.setValue("b", signature);
    }

    @Override
    public void setBodyHash(byte[] newBodyHash) {
        String bodyHash = new String(Base64.encodeBase64(newBodyHash));
        this.setValue("bh", bodyHash);
        if (this.getValue("t") != null && this.getValue("t").toString().trim().isEmpty()) {
            this.setValue("t", "" + System.currentTimeMillis() / 1000L);
        }
    }

    public SignatureRecordImpl toSignatureRecord(SigningAlgorithm algorithm, HashMethod hashMethod, byte[] bodyHash, byte[] signature) {
        this.setValue("a", algorithm.asTagValue() + "-" + hashMethod.asTagValue());
        String bodyHashTagValue = new String(Base64.encodeBase64(bodyHash));
        this.setValue("bh", bodyHashTagValue);
        String signatureTagValue = new String(Base64.encodeBase64(signature));
        this.setValue("b", signatureTagValue);
        if (this.getValue("t") != null && this.getValue("t").toString().trim().isEmpty()) {
            this.setValue("t", "" + System.currentTimeMillis() / 1000L);
        }
        return new SignatureRecordImpl(this.toString());
    }

    @Override
    public String toUnsignedString() {
        return this.toString().replaceFirst("b=[^;]*", "b=");
    }
}

