/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.tagvalue.SignatureRecordImpl;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SignatureRecordImplTest {
    @Test
    public void testBasic() {
        new SignatureRecordImpl("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=");
    }

    @Test
    public void testWrongOrMissingVersion() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SignatureRecordImpl("a=rsa-sha1; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        b=Kw/TqnjB4L5ZC7DX1ibiNkuIw630uHZvzuozn/e6yTm3U8ObWEz/rJK5GO8RSrF56JrCA/xo8W2CGmyNmpQYbEpLl5P9/NcJSYUmln/O6GSa4Usyv4FdEU4FVjkyW0ToGFHNkw9Mm0urveA4Lcfk9gClJczXnvGBdiv/bkVBEJk=")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("mandatory").hasMessageContaining("v");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SignatureRecordImpl("v=2; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Invalid").hasMessageContaining("version").hasMessageContaining("2");
    }

    @Test
    public void testMissingRequired() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SignatureRecordImpl("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("mandatory").hasMessageContaining("bh");
    }

    @Test
    public void testDomainMismatch() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SignatureRecordImpl("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta; i=@agmail.com;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("domain mismatch");
    }

    @Test
    public void testMissingFrom() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SignatureRecordImpl("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta; i=@subdomain.gmail.com;\r\n        h=domainkey-signature:received:received:message-id:date:fram:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=")).isInstanceOf(IllegalStateException.class)).hasMessage("From field not signed");
    }

    @Test
    public void testWrongHashSyntaxes() {
        SignatureRecordImpl sr = new SignatureRecordImpl("v=1; a=nothyphenedword; bh=abcdef; b=1235345987; h=from:to; s=select; d=example.com");
        Assertions.assertThatThrownBy(() -> ((SignatureRecord)sr).getHashAlgo()).hasMessageContaining("hash");
        Assertions.assertThatThrownBy(() -> ((SignatureRecord)sr).getHashMethod()).hasMessageContaining("hash");
    }

    @Test
    public void testExpired() {
        Assertions.assertThatThrownBy(() -> new SignatureRecordImpl("v=1; c=simple; h=from:to; s=select; d=example.com; a=rsa-sha1; x=0; bh=abcdef; b=1235345987;")).hasMessageContaining("expired");
    }
}

