/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.taglib;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.taglib.ExceptionAwareTagSupport;
import org.apache.logging.log4j.taglib.Log4jTaglibLogger;
import org.apache.logging.log4j.taglib.TagUtils;

abstract class LoggingMessageTagSupport
extends ExceptionAwareTagSupport
implements DynamicAttributes {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LoggingMessageTagSupport.class.getName();
    private transient Object message;
    private Marker marker;
    private List<Object> attributes;

    LoggingMessageTagSupport() {
    }

    @Override
    protected void init() {
        super.init();
        this.message = null;
        this.marker = null;
        if (this.attributes == null) {
            this.attributes = new ArrayList<Object>();
        } else {
            this.attributes.clear();
        }
    }

    protected final Object getMessage() throws JspException {
        if (this.message == null) {
            if (this.getBodyContent() == null) {
                throw new JspException("Either message attribute or body content must be specified.");
            }
            return this.getBodyContent().getString();
        }
        return this.message;
    }

    public final void setMessage(Object message) {
        this.message = message;
    }

    protected final Marker getMarker() {
        return this.marker;
    }

    public final void setMarker(Marker marker) {
        this.marker = marker;
    }

    protected abstract Level getLevel();

    public final void setDynamicAttribute(String uri, String name, Object value) {
        this.attributes.add(value);
    }

    public final int doStartTag() {
        return 2;
    }

    public final int doEndTag() throws JspException {
        Marker marker;
        Level level;
        Log4jTaglibLogger logger = this.getLogger();
        if (TagUtils.isEnabled(logger, level = this.getLevel(), marker = this.getMarker())) {
            Object message = this.getMessage();
            Throwable exception = this.getException();
            if (message instanceof Message) {
                logger.logIfEnabled(FQCN, level, marker, (Message)message, exception);
            } else if (message instanceof String) {
                Message data = this.attributes.size() > 0 ? logger.getMessageFactory().newMessage((String)message, this.attributes.toArray()) : logger.getMessageFactory().newMessage((String)message);
                logger.logIfEnabled(FQCN, level, marker, data, exception);
            } else {
                logger.logIfEnabled(FQCN, level, marker, logger.getMessageFactory().newMessage(message), exception);
            }
        }
        return 6;
    }
}

