/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.ee;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import javax.naming.InitialContext;
import javax.transaction.xa.XAResource;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.lib.util.Localizer;

public class RegistryManagedRuntime
implements ManagedRuntime {
    private String _registryName = "java:comp/TransactionSynchronizationRegistry";
    private TransactionManagerRegistryFacade _tm = null;
    private static Localizer _loc = Localizer.forPackage(RegistryManagedRuntime.class);

    @Override
    public TransactionManager getTransactionManager() throws Exception {
        if (this._tm == null) {
            try (InitialContext ctx = new InitialContext();){
                this._tm = new TransactionManagerRegistryFacade((TransactionSynchronizationRegistry)ctx.lookup(this._registryName));
            }
        }
        return this._tm;
    }

    @Override
    public void setRollbackOnly(Throwable cause) throws Exception {
        this.getTransactionManager().getTransaction().setRollbackOnly();
    }

    @Override
    public Throwable getRollbackCause() throws Exception {
        return null;
    }

    public void setRegistryName(String registryName) {
        this._registryName = registryName;
    }

    public String getRegistryName() {
        return this._registryName;
    }

    @Override
    public Object getTransactionKey() throws Exception, SystemException {
        return this._tm.getTransactionKey();
    }

    @Override
    public void doNonTransactionalWork(Runnable runnable) throws NotSupportedException {
        throw new NotSupportedException(_loc.get("tsr-cannot-suspend").getMessage());
    }

    public class TransactionManagerRegistryFacade
    implements TransactionManager,
    Transaction {
        private final TransactionSynchronizationRegistry _registry;

        public TransactionManagerRegistryFacade(TransactionSynchronizationRegistry registry) {
            this._registry = registry;
        }

        @Override
        public Transaction getTransaction() throws SystemException {
            return this;
        }

        @Override
        public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
            this._registry.registerInterposedSynchronization(sync);
        }

        @Override
        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this._registry.setRollbackOnly();
        }

        @Override
        public int getStatus() throws SystemException {
            return this._registry.getTransactionStatus();
        }

        public Object getTransactionKey() {
            return this._registry.getTransactionKey();
        }

        @Override
        public void begin() throws NotSupportedException, SystemException {
            throw new NotSupportedException();
        }

        @Override
        public void commit() throws RollbackException, HeuristicMixedException, SystemException, HeuristicRollbackException, SecurityException, IllegalStateException {
            throw new SystemException();
        }

        @Override
        public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
            throw new SystemException();
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            throw new SystemException();
        }

        @Override
        public void setTransactionTimeout(int seconds) throws SystemException {
            throw new SystemException();
        }

        @Override
        public Transaction suspend() throws SystemException {
            throw new SystemException();
        }

        @Override
        public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
            throw new SystemException();
        }

        @Override
        public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
            throw new SystemException();
        }
    }
}

