/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.messages;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;

public class ByteArrayMessageSink
extends AbstractMessageSink {
    private RetainableByteBuffer.DynamicCapacity accumulator;

    public ByteArrayMessageSink(CoreSession session, MethodHolder methodHolder, boolean autoDemand) {
        super(session, methodHolder, autoDemand);
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            long size = (this.accumulator == null ? 0L : this.accumulator.size()) + (long)frame.getPayloadLength();
            long maxSize = this.getCoreSession().getMaxBinaryMessageSize();
            if (maxSize > 0L && size > maxSize) {
                callback.failed((Throwable)new MessageTooLargeException(String.format("Binary message too large: %,d > %,d", size, maxSize)));
                return;
            }
            ByteBuffer payload = frame.getPayload();
            if (frame.isFin() && (this.accumulator == null || this.accumulator.isEmpty())) {
                byte[] buf = BufferUtil.toArray((ByteBuffer)payload);
                this.getMethodHolder().invoke(buf, 0, buf.length);
                callback.succeeded();
                this.autoDemand();
                return;
            }
            if (!frame.isFin() && !frame.hasPayload()) {
                callback.succeeded();
                this.getCoreSession().demand();
                return;
            }
            if (this.accumulator == null) {
                this.accumulator = new RetainableByteBuffer.DynamicCapacity();
            }
            this.accumulator.add((RetainableByteBuffer)RetainableByteBuffer.wrap((ByteBuffer)payload, () -> ((Callback)callback).succeeded()));
            if (frame.isFin()) {
                callback = Callback.NOOP;
                int length = this.accumulator.remaining();
                byte[] buf = this.accumulator.takeByteArray();
                this.getMethodHolder().invoke(buf, 0, length);
                this.autoDemand();
            } else {
                this.getCoreSession().demand();
            }
        }
        catch (Throwable t) {
            this.fail(t);
            callback.failed(t);
        }
    }

    @Override
    public void fail(Throwable failure) {
        if (this.accumulator != null) {
            this.accumulator.clear();
        }
    }
}

