/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.EventManager;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageMetaDataTypeRegistry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.handler.DistributedTransactionHandler;
import org.apache.qpid.server.store.handler.MessageHandler;
import org.apache.qpid.server.store.handler.MessageInstanceHandler;
import org.apache.qpid.server.store.jdbc.JdbcUtils;
import org.apache.qpid.server.txn.Xid;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.CachingUUIDFactory;
import org.apache.qpid.server.util.CollectionUtils;
import org.slf4j.Logger;

public abstract class AbstractJDBCMessageStore
implements MessageStore {
    private static final String DB_VERSION_TABLE_NAME_SUFFIX = "QPID_DB_VERSION";
    private static final String QUEUE_ENTRY_TABLE_NAME_SUFFIX = "QPID_QUEUE_ENTRIES";
    private static final String META_DATA_TABLE_NAME_SUFFIX = "QPID_MESSAGE_METADATA";
    private static final String MESSAGE_CONTENT_TABLE_NAME_SUFFIX = "QPID_MESSAGE_CONTENT";
    private static final String XID_TABLE_NAME_SUFFIX = "QPID_XIDS";
    private static final String XID_ACTIONS_TABLE_NAME_SUFFIX = "QPID_XID_ACTIONS";
    private static final int IN_CLAUSE_MAX_SIZE_DEFAULT = 1000;
    static final String IN_CLAUSE_MAX_SIZE = "qpid.jdbcstore.inClauseMaxSize";
    private static final int EXECUTOR_THREADS_DEFAULT = Runtime.getRuntime().availableProcessors();
    private static final String EXECUTOR_THREADS = "qpid.jdbcstore.executorThreads";
    private static final String EXECUTOR_SHUTDOWN_TIMEOUT = "qpid.jdbcstore.executorShutdownTimeoutInSeconds";
    private static final int EXECUTOR_SHUTDOWN_TIMEOUT_DEFAULT = 5;
    private static final int DB_VERSION = 8;
    private final AtomicLong _messageId = new AtomicLong(0L);
    private static final List<Long> EMPTY_LIST = Collections.emptyList();
    private final AtomicReference<List<Long>> _messagesToDelete = new AtomicReference<List<Long>>(EMPTY_LIST);
    private final AtomicBoolean _messageRemovalScheduled = new AtomicBoolean();
    protected final EventManager _eventManager = new EventManager();
    private ConfiguredObject<?> _parent;
    private String _tablePrefix = "";
    private final AtomicLong _inMemorySize = new AtomicLong();
    private final AtomicLong _bytesEvacuatedFromMemory = new AtomicLong();
    private final Set<StoredJDBCMessage<?>> _messages = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<MessageStore.MessageDeleteListener> _messageDeleteListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Action<Connection>> _deleteActions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Thread.UncaughtExceptionHandler _uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    private ScheduledThreadPoolExecutor _executor;
    private volatile int _inClauseMaxSize;
    private volatile int _executorShutdownTimeOut;

    protected abstract boolean isMessageStoreOpen();

    protected abstract void checkMessageStoreOpen();

    protected void setMaximumMessageId() {
        try (Connection conn = this.newAutoCommitConnection();){
            this.setMaxMessageId(conn, "SELECT max(message_id) FROM " + this.getMessageContentTableName(), 1);
            this.setMaxMessageId(conn, "SELECT max(message_id) FROM " + this.getMetaDataTableName(), 1);
            this.setMaxMessageId(conn, "SELECT queue_id, max(message_id) FROM " + this.getQueueEntryTableName() + " GROUP BY queue_id ", 2);
        }
        catch (SQLException e) {
            throw new StoreException("Failed to determine maximum ids", (Throwable)e);
        }
    }

    private void setMaxMessageId(Connection conn, String query, int col) throws SQLException {
        try (PreparedStatement statement = conn.prepareStatement(query);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                long maxMessageId = rs.getLong(col);
                if (this._messageId.get() >= maxMessageId) continue;
                this._messageId.set(maxMessageId);
            }
        }
    }

    protected void upgrade(ConfiguredObject<?> parent) throws StoreException {
        try (Connection conn = this.newAutoCommitConnection();){
            if (this.tableExists(this.getDbVersionTableName(), conn)) {
                this.upgradeIfNecessary(parent);
            }
        }
        catch (SQLException e) {
            throw new StoreException("Failed to upgrade database", (Throwable)e);
        }
    }

    private void upgradeIfNecessary(ConfiguredObject<?> parent) throws SQLException {
        try (Connection conn = this.newAutoCommitConnection();
             PreparedStatement statement = conn.prepareStatement("SELECT version FROM " + this.getDbVersionTableName());
             ResultSet rs = statement.executeQuery();){
            if (!rs.next()) {
                throw new StoreException(this.getDbVersionTableName() + " does not contain the database version");
            }
            int version = rs.getInt(1);
            switch (version) {
                case 6: {
                    this.upgradeFromV6();
                }
                case 7: {
                    this.upgradeFromV7();
                }
                case 8: {
                    return;
                }
            }
            throw new StoreException("Unknown database version: " + version);
        }
    }

    private void upgradeFromV7() throws SQLException {
        this.updateDbVersion(8);
    }

    private void upgradeFromV6() throws SQLException {
        this.updateDbVersion(7);
    }

    private void updateDbVersion(int newVersion) throws SQLException {
        try (Connection conn = this.newAutoCommitConnection();
             PreparedStatement statement = conn.prepareStatement("UPDATE " + this.getDbVersionTableName() + " SET version = ?");){
            statement.setInt(1, newVersion);
            statement.execute();
        }
    }

    protected void initMessageStore(final ConfiguredObject<?> parent) {
        this._parent = parent;
        int corePoolSize = this.getContextValue(Integer.class, EXECUTOR_THREADS, EXECUTOR_THREADS_DEFAULT);
        this._executorShutdownTimeOut = this.getContextValue(Integer.class, EXECUTOR_SHUTDOWN_TIMEOUT, 5);
        this._executor = new ScheduledThreadPoolExecutor(corePoolSize, new ThreadFactory(){
            private final AtomicInteger _count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName(parent.getName() + "-store-" + this._count.incrementAndGet());
                return thread;
            }
        });
        this._executor.prestartAllCoreThreads();
        this._inClauseMaxSize = this.getContextValue(Integer.class, IN_CLAUSE_MAX_SIZE, 1000);
    }

    public void closeMessageStore() {
        for (StoredJDBCMessage<?> message : this._messages) {
            message.clear(true);
        }
        this._messages.clear();
        this._inMemorySize.set(0L);
        this._bytesEvacuatedFromMemory.set(0L);
        if (this._executor != null) {
            this._executor.shutdown();
            if (this._executorShutdownTimeOut > 0) {
                try {
                    if (!this._executor.awaitTermination(this._executorShutdownTimeOut, TimeUnit.SECONDS)) {
                        this._executor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.getLogger().warn("Interrupted during store executor shutdown:", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected abstract Logger getLogger();

    protected abstract String getSqlBlobType();

    protected abstract String getSqlBlobStorage(String var1);

    protected abstract String getSqlVarBinaryType(int var1);

    protected abstract String getSqlBigIntType();

    protected void createOrOpenMessageStoreDatabase() throws StoreException {
        try (Connection conn = this.newAutoCommitConnection();){
            this.createVersionTable(conn);
            this.createQueueEntryTable(conn);
            this.createMetaDataTable(conn);
            this.createMessageContentTable(conn);
            this.createXidTable(conn);
            this.createXidActionTable(conn);
        }
        catch (SQLException e) {
            throw new StoreException("Failed to create message store tables", (Throwable)e);
        }
    }

    private void createVersionTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getDbVersionTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getDbVersionTableName() + " ( version int not null )");
            }
            try (PreparedStatement pstmt = conn.prepareStatement("INSERT INTO " + this.getDbVersionTableName() + " ( version ) VALUES ( ? )");){
                pstmt.setInt(1, 8);
                pstmt.execute();
            }
        }
    }

    private void createQueueEntryTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getQueueEntryTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getQueueEntryTableName() + " ( queue_id varchar(36) not null, message_id " + this.getSqlBigIntType() + " not null, PRIMARY KEY (queue_id, message_id) )");
            }
        }
    }

    private void createMetaDataTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getMetaDataTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getMetaDataTableName() + " ( message_id " + this.getSqlBigIntType() + " not null, meta_data " + this.getSqlBlobType() + ", PRIMARY KEY ( message_id ) ) " + this.getSqlBlobStorage("meta_data"));
            }
        }
    }

    private void createMessageContentTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getMessageContentTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getMessageContentTableName() + " ( message_id " + this.getSqlBigIntType() + " not null, content " + this.getSqlBlobType() + ", PRIMARY KEY (message_id) ) " + this.getSqlBlobStorage("content"));
            }
        }
    }

    private void createXidTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getXidTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getXidTableName() + " ( format " + this.getSqlBigIntType() + " not null, global_id " + this.getSqlVarBinaryType(64) + ", branch_id " + this.getSqlVarBinaryType(64) + " ,  PRIMARY KEY ( format, global_id, branch_id ))");
            }
        }
    }

    private void createXidActionTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getXidActionsTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getXidActionsTableName() + " ( format " + this.getSqlBigIntType() + " not null, global_id " + this.getSqlVarBinaryType(64) + " not null, branch_id " + this.getSqlVarBinaryType(64) + " not null, action_type char not null, queue_id varchar(36) not null, message_id " + this.getSqlBigIntType() + " not null,  PRIMARY KEY ( format, global_id, branch_id, action_type, queue_id, message_id))");
            }
        }
    }

    protected boolean tableExists(String tableName, Connection conn) throws SQLException {
        return JdbcUtils.tableExists(tableName, conn);
    }

    public <T extends StorableMessageMetaData> MessageHandle<T> addMessage(T metaData) {
        this.checkMessageStoreOpen();
        return this.createStoredJDBCMessage(this.getNextMessageId(), metaData, false);
    }

    public <T extends StorableMessageMetaData> StoredJDBCMessage<T> createStoredJDBCMessage(long newMessageId, T metaData, boolean recovered) {
        StoredJDBCMessage message = new StoredJDBCMessage(this, newMessageId, metaData, recovered);
        this._messages.add(message);
        return message;
    }

    public long getNextMessageId() {
        return this._messageId.incrementAndGet();
    }

    private void removeMessageAsync(long messageId) {
        List<Long> updated;
        List<Long> orig;
        do {
            orig = this._messagesToDelete.get();
            updated = new ArrayList<Long>(orig.size() + 1);
            updated.addAll(orig);
            updated.add(messageId);
        } while (!this._messagesToDelete.compareAndSet(orig, updated = Collections.unmodifiableList(updated)));
        this.scheduleMessageRemoval();
    }

    private void scheduleMessageRemoval() {
        if (this._messageRemovalScheduled.compareAndSet(false, true)) {
            try {
                this._executor.submit(this::removeScheduledMessages);
            }
            catch (RejectedExecutionException e) {
                this._messageRemovalScheduled.set(false);
                throw new IllegalStateException("Cannot schedule removal of messages", e);
            }
        }
    }

    private void removeScheduledMessages() {
        try {
            this.removeScheduledMessagesAndRescheduleIfRequired();
        }
        catch (RuntimeException e) {
            this.handleExceptionOnScheduledMessageRemoval(e);
        }
    }

    private void removeScheduledMessagesAndRescheduleIfRequired() {
        try {
            List<Long> messageIds;
            do {
                messageIds = this._messagesToDelete.getAndSet(EMPTY_LIST);
                this.removeMessages(messageIds);
            } while (!messageIds.isEmpty());
        }
        finally {
            this._messageRemovalScheduled.set(false);
        }
        if (!this._messagesToDelete.get().isEmpty() && this.isMessageStoreOpen()) {
            this.scheduleMessageRemoval();
        }
    }

    private void handleExceptionOnScheduledMessageRemoval(RuntimeException e) {
        if (this.isMessageStoreOpen()) {
            if (this._uncaughtExceptionHandler == null) {
                this.getLogger().error("Unexpected exception on asynchronous message removal", (Throwable)e);
            } else {
                this._uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
            }
        } else {
            this.getLogger().warn("Ignoring unexpected exception on asynchronous message removal as store is not open", (Throwable)e);
        }
    }

    boolean isMessageRemovalScheduled() {
        return this._messageRemovalScheduled.get();
    }

    void removeMessages(List<Long> messageIds) {
        if (messageIds != null && !messageIds.isEmpty()) {
            try (Connection conn = this.newConnection();){
                try {
                    for (List boundMessageIds : CollectionUtils.partitions(messageIds, (int)this._inClauseMaxSize)) {
                        this.removeMessagesFromDatabase(conn, boundMessageIds);
                    }
                }
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            catch (SQLException e) {
                throw new StoreException("Error removing messages with ids " + String.valueOf(messageIds) + " from database: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    void removeMessagesFromDatabase(Connection conn, List<Long> messageIds) throws SQLException {
        String inpart = messageIds.stream().map(Object::toString).collect(Collectors.joining(", ", "(", ")"));
        try (Statement stmt = conn.createStatement();){
            int results = stmt.executeUpdate("DELETE FROM " + this.getMetaDataTableName() + " WHERE message_id IN " + inpart);
            stmt.close();
            if (results != messageIds.size()) {
                this.getLogger().debug("Some message ids in {} not found (attempt to remove failed - probably application initiated rollback)", messageIds);
            }
            this.getLogger().debug("Deleted metadata for messages {}", messageIds);
        }
        stmt = conn.createStatement();
        try {
            stmt.executeUpdate("DELETE FROM " + this.getMessageContentTableName() + " WHERE message_id IN " + inpart);
            this.getLogger().debug("Deleted content for messages {}", messageIds);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        conn.commit();
    }

    protected Connection newAutoCommitConnection() throws SQLException {
        Connection connection = this.newConnection();
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    protected Connection newConnection() throws SQLException {
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    public abstract Connection getConnection() throws SQLException;

    public Transaction newTransaction() {
        this.checkMessageStoreOpen();
        return new JDBCTransaction();
    }

    private void enqueueMessages(ConnectionWrapper connWrapper, Map<Long, List<TransactionLogResource>> queuesPerMessage) throws StoreException {
        if (queuesPerMessage.isEmpty()) {
            return;
        }
        Connection conn = connWrapper.getConnection();
        String sql = String.format("INSERT INTO %s (queue_id, message_id) values (?,?)", this.getQueueEntryTableName());
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            for (Long messageId : queuesPerMessage.keySet()) {
                for (TransactionLogResource queue : queuesPerMessage.get(messageId)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Enqueuing message {} on queue {} with id {} [Connection {}]", new Object[]{messageId, queue.getName(), queue.getId(), conn});
                    }
                    stmt.setString(1, queue.getId().toString());
                    stmt.setLong(2, messageId);
                    stmt.addBatch();
                }
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to enqueue messages", (Throwable)e);
            throw new StoreException("Error writing enqueued messages to database", (Throwable)e);
        }
    }

    private void dequeueMessage(ConnectionWrapper connWrapper, UUID queueId, Long messageId) throws StoreException {
        Connection conn = connWrapper.getConnection();
        try (PreparedStatement stmt = conn.prepareStatement("DELETE FROM " + this.getQueueEntryTableName() + " WHERE queue_id = ? AND message_id =?");){
            stmt.setString(1, queueId.toString());
            stmt.setLong(2, messageId);
            int results = stmt.executeUpdate();
            if (results != 1) {
                throw new StoreException("Unable to find message with id " + messageId + " on queue with id " + String.valueOf(queueId));
            }
            this.getLogger().debug("Dequeuing message {} on queue with id {}", (Object)messageId, (Object)queueId);
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to dequeue message {}", (Object)messageId, (Object)e);
            throw new StoreException("Error deleting enqueued message with id " + messageId + " for queue with id " + String.valueOf(queueId) + " from database", (Throwable)e);
        }
    }

    private void removeXid(ConnectionWrapper connWrapper, long format, byte[] globalId, byte[] branchId) throws StoreException {
        Connection conn = connWrapper.getConnection();
        try {
            try (PreparedStatement stmt = conn.prepareStatement("DELETE FROM " + this.getXidTableName() + " WHERE format = ? and global_id = ? and branch_id = ?");){
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                int results = stmt.executeUpdate();
                if (results != 1) {
                    throw new StoreException("Unable to find message with xid");
                }
            }
            stmt = conn.prepareStatement("DELETE FROM " + this.getXidActionsTableName() + " WHERE format = ? and global_id = ? and branch_id = ?");
            try {
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                int n = stmt.executeUpdate();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to remove xid", (Throwable)e);
            throw new StoreException("Error deleting enqueued message with xid", (Throwable)e);
        }
    }

    private List<Runnable> recordXid(ConnectionWrapper connWrapper, long format, byte[] globalId, byte[] branchId, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) throws StoreException {
        Connection conn = connWrapper.getConnection();
        try {
            try (Object stmt = conn.prepareStatement("INSERT INTO " + this.getXidTableName() + " ( format, global_id, branch_id ) values (?, ?, ?)");){
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                stmt.executeUpdate();
            }
            for (Transaction.EnqueueRecord enqueue : enqueues) {
                StoredMessage storedMessage = enqueue.getMessage().getStoredMessage();
                if (!(storedMessage instanceof StoredJDBCMessage)) continue;
                ((StoredJDBCMessage)storedMessage).store(conn);
            }
            stmt = conn.prepareStatement("INSERT INTO " + this.getXidActionsTableName() + " ( format, global_id, branch_id, action_type, queue_id, message_id ) values (?,?,?,?,?,?) ");
            try {
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                if (enqueues != null) {
                    stmt.setString(4, "E");
                    for (Transaction.EnqueueRecord enqueueRecord : enqueues) {
                        stmt.setString(5, enqueueRecord.getResource().getId().toString());
                        stmt.setLong(6, enqueueRecord.getMessage().getMessageNumber());
                        stmt.executeUpdate();
                    }
                }
                if (dequeues != null) {
                    stmt.setString(4, "D");
                    for (Transaction.DequeueRecord dequeueRecord : dequeues) {
                        stmt.setString(5, dequeueRecord.getEnqueueRecord().getQueueId().toString());
                        stmt.setLong(6, dequeueRecord.getEnqueueRecord().getMessageNumber());
                        stmt.executeUpdate();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            return Collections.emptyList();
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to record xid", (Throwable)e);
            throw new StoreException("Error writing xid ", (Throwable)e);
        }
    }

    protected void setTablePrefix(String tablePrefix) {
        this._tablePrefix = tablePrefix == null ? "" : tablePrefix;
    }

    private String getDbVersionTableName() {
        return this._tablePrefix + DB_VERSION_TABLE_NAME_SUFFIX;
    }

    private String getQueueEntryTableName() {
        return this._tablePrefix + QUEUE_ENTRY_TABLE_NAME_SUFFIX;
    }

    private String getMetaDataTableName() {
        return this._tablePrefix + META_DATA_TABLE_NAME_SUFFIX;
    }

    private String getMessageContentTableName() {
        return this._tablePrefix + MESSAGE_CONTENT_TABLE_NAME_SUFFIX;
    }

    private String getXidTableName() {
        return this._tablePrefix + XID_TABLE_NAME_SUFFIX;
    }

    private String getXidActionsTableName() {
        return this._tablePrefix + XID_ACTIONS_TABLE_NAME_SUFFIX;
    }

    public void addDeleteAction(Action<Connection> action) {
        this._deleteActions.add(action);
    }

    public void removeDeleteAction(Action<Connection> action) {
        this._deleteActions.remove(action);
    }

    private void commitTran(ConnectionWrapper connWrapper) throws StoreException {
        try {
            Connection conn = connWrapper.getConnection();
            conn.commit();
            this.getLogger().debug("commit tran completed");
            conn.close();
        }
        catch (SQLException e) {
            throw new StoreException("Error commit tx", (Throwable)e);
        }
    }

    private <X> CompletableFuture<X> commitTranAsync(ConnectionWrapper connWrapper, X val) throws StoreException {
        CompletableFuture future = new CompletableFuture();
        this._executor.submit(() -> {
            try {
                this.commitTran(connWrapper);
                future.complete(val);
            }
            catch (RuntimeException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private void abortTran(ConnectionWrapper connWrapper) throws StoreException {
        if (connWrapper == null) {
            throw new StoreException("Fatal internal error: transactional context is empty at abortTran");
        }
        this.getLogger().debug("abort tran called: {}", (Object)connWrapper.getConnection());
        try {
            Connection conn = connWrapper.getConnection();
            conn.rollback();
            conn.close();
        }
        catch (SQLException e) {
            throw new StoreException("Error aborting transaction: " + e.getMessage(), (Throwable)e);
        }
    }

    private void storeMetaData(Connection conn, long messageId, StorableMessageMetaData metaData) throws SQLException {
        this.getLogger().debug("Adding metadata for message {}", (Object)messageId);
        try (PreparedStatement stmt = conn.prepareStatement("INSERT INTO " + this.getMetaDataTableName() + "( message_id , meta_data ) values (?, ?)");){
            stmt.setLong(1, messageId);
            int bodySize = 1 + metaData.getStorableSize();
            byte[] underlying = new byte[bodySize];
            underlying[0] = (byte)metaData.getType().ordinal();
            try (QpidByteBuffer buf = QpidByteBuffer.wrap((byte[])underlying);){
                buf.position(1);
                try (QpidByteBuffer bufSlice = buf.slice();){
                    metaData.writeToBuffer(buf);
                }
            }
            try (ByteArrayInputStream bis = new ByteArrayInputStream(underlying);){
                stmt.setBinaryStream(2, (InputStream)bis, underlying.length);
                int result = stmt.executeUpdate();
                if (result == 0) {
                    throw new StoreException("Unable to add meta data for message " + messageId);
                }
            }
            catch (IOException e) {
                throw new SQLException("Failed to close ByteArrayInputStream", e);
            }
        }
    }

    private StorableMessageMetaData getMetaData(long messageId) throws SQLException {
        try (Connection conn = this.newAutoCommitConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT meta_data FROM " + this.getMetaDataTableName() + " WHERE message_id = ?");){
            stmt.setLong(1, messageId);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    StorableMessageMetaData storableMessageMetaData;
                    block30: {
                        InputStream blobAsInputStream = this.getBlobAsInputStream(rs, 1);
                        try {
                            storableMessageMetaData = this.getStorableMessageMetaData(messageId, blobAsInputStream);
                            if (blobAsInputStream == null) break block30;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (blobAsInputStream != null) {
                                    try {
                                        blobAsInputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new StoreException("Error reading meta data from the store for message with id " + messageId, (Throwable)e);
                            }
                        }
                        blobAsInputStream.close();
                    }
                    return storableMessageMetaData;
                }
                throw new StoreException("Meta data not found for message with id " + messageId);
            }
        }
    }

    private StorableMessageMetaData getStorableMessageMetaData(long messageId, InputStream stream) throws SQLException {
        StorableMessageMetaData storableMessageMetaData;
        block8: {
            int typeOrdinal = stream.read() & 0xFF;
            MessageMetaDataType type = MessageMetaDataTypeRegistry.fromOrdinal((int)typeOrdinal);
            QpidByteBuffer buf = QpidByteBuffer.asQpidByteBuffer((InputStream)stream);
            try {
                storableMessageMetaData = type.createMetaData(buf);
                if (buf == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (buf != null) {
                        try {
                            buf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new StoreException("Failed to stream metadata for message with id " + messageId, (Throwable)e);
                }
            }
            buf.close();
        }
        return storableMessageMetaData;
    }

    protected abstract InputStream getBlobAsInputStream(ResultSet var1, int var2) throws SQLException;

    private void addContent(Connection conn, long messageId, QpidByteBuffer contentBody) {
        this.getLogger().debug("Adding content for message {}", (Object)messageId);
        try (PreparedStatement stmt = conn.prepareStatement("INSERT INTO " + this.getMessageContentTableName() + "( message_id, content ) values (?, ?)");
             QpidByteBuffer bodyDuplicate = contentBody.duplicate();
             InputStream inputStream = bodyDuplicate.asInputStream();){
            stmt.setLong(1, messageId);
            stmt.setBinaryStream(2, inputStream, contentBody.remaining());
            stmt.executeUpdate();
        }
        catch (IOException | SQLException e) {
            JdbcUtils.closeConnection(conn, this.getLogger());
            throw new StoreException("Error adding content for message " + messageId + ": " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    QpidByteBuffer getAllContent(long messageId) throws StoreException {
        this.getLogger().debug("Message Id: {} Getting content body", (Object)messageId);
        try (Connection conn = this.newAutoCommitConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT content FROM " + this.getMessageContentTableName() + " WHERE message_id = ?");){
            stmt.setLong(1, messageId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) throw new StoreException("Unable to find message with id " + messageId);
            try (InputStream blobAsInputStream = this.getBlobAsInputStream(rs, 1);){
                QpidByteBuffer qpidByteBuffer = QpidByteBuffer.asQpidByteBuffer((InputStream)blobAsInputStream);
                return qpidByteBuffer;
            }
        }
        catch (IOException | SQLException e) {
            throw new StoreException("Error retrieving content for message " + messageId + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isPersistent() {
        return true;
    }

    public long getInMemorySize() {
        return this._inMemorySize.get();
    }

    public long getBytesEvacuatedFromMemory() {
        return this._bytesEvacuatedFromMemory.get();
    }

    public void resetStatistics() {
        this._bytesEvacuatedFromMemory.set(0L);
    }

    public void addMessageDeleteListener(MessageStore.MessageDeleteListener listener) {
        this._messageDeleteListeners.add(listener);
    }

    public void removeMessageDeleteListener(MessageStore.MessageDeleteListener listener) {
        this._messageDeleteListeners.remove(listener);
    }

    public void addEventListener(EventListener eventListener, Event ... events) {
        this._eventManager.addEventListener(eventListener, events);
    }

    public MessageStore.MessageStoreReader newMessageStoreReader() {
        return new JDBCMessageStoreReader();
    }

    protected abstract void storedSizeChange(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDelete(Connection conn) {
        try {
            for (Action<Connection> deleteAction : this._deleteActions) {
                deleteAction.performAction((Object)conn);
            }
            this._deleteActions.clear();
        }
        finally {
            JdbcUtils.dropTables(conn, this.getLogger(), this.getTableNames());
        }
    }

    public List<String> getTableNames() {
        return Arrays.asList(this.getDbVersionTableName(), this.getMetaDataTableName(), this.getMessageContentTableName(), this.getQueueEntryTableName(), this.getXidTableName(), this.getXidActionsTableName());
    }

    private <T> T getContextValue(Class<T> variableClass, String name, T defaultValue) {
        if (this._parent.getContextKeys(false).contains(name)) {
            return (T)this._parent.getContextValue(variableClass, name);
        }
        return defaultValue;
    }

    private class StoredJDBCMessage<T extends StorableMessageMetaData>
    implements StoredMessage<T>,
    MessageHandle<T> {
        private final long _messageId;
        private final int _contentSize;
        private final int _metadataSize;
        private MessageDataRef<T> _messageDataRef;
        final /* synthetic */ AbstractJDBCMessageStore this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        StoredJDBCMessage(long metaData, T t, boolean bl) {
            void isRecovered;
            void messageId;
            this.this$0 = (AbstractJDBCMessageStore)l;
            this._messageId = messageId;
            this._messageDataRef = new MessageDataRef<long>(metaData, isRecovered == false);
            this._contentSize = metaData.getContentSize();
            this._metadataSize = metaData.getStorableSize();
            l._inMemorySize.addAndGet(this._metadataSize);
        }

        public synchronized T getMetaData() {
            if (this._messageDataRef == null) {
                return null;
            }
            Object metaData = this._messageDataRef.getMetaData();
            if (metaData == null) {
                this.this$0.checkMessageStoreOpen();
                try {
                    metaData = this.this$0.getMetaData(this._messageId);
                    this._messageDataRef = new MessageDataRef<T>(metaData, this._messageDataRef.getData(), false);
                    this.this$0._inMemorySize.addAndGet(this.getMetadataSize());
                }
                catch (SQLException e) {
                    throw new StoreException("Failed to get metadata for message id: " + this._messageId, (Throwable)e);
                }
            }
            return metaData;
        }

        public long getMessageNumber() {
            return this._messageId;
        }

        public synchronized void addContent(QpidByteBuffer src) {
            try (QpidByteBuffer data = this._messageDataRef.getData();){
                if (data == null) {
                    this._messageDataRef.setData(src.slice());
                } else {
                    this._messageDataRef.setData(QpidByteBuffer.concatenate(Arrays.asList(data, src)));
                }
            }
        }

        public StoredMessage<T> allContentAdded() {
            this.this$0._inMemorySize.addAndGet(this.getContentSize());
            return this;
        }

        private QpidByteBuffer getContentAsByteBuffer() {
            QpidByteBuffer data;
            QpidByteBuffer qpidByteBuffer = data = this._messageDataRef == null ? QpidByteBuffer.emptyQpidByteBuffer() : this._messageDataRef.getData();
            if (data == null) {
                if (this.stored()) {
                    this.this$0.checkMessageStoreOpen();
                    data = this.this$0.getAllContent(this._messageId);
                    this._messageDataRef.setData(data);
                    this.this$0._inMemorySize.addAndGet(this.getContentSize());
                } else {
                    data = QpidByteBuffer.emptyQpidByteBuffer();
                }
            }
            return data;
        }

        public synchronized QpidByteBuffer getContent(int offset, int length) {
            QpidByteBuffer contentAsByteBuffer = this.getContentAsByteBuffer();
            if (length == Integer.MAX_VALUE) {
                length = contentAsByteBuffer.remaining();
            }
            return contentAsByteBuffer.view(offset, length);
        }

        public int getContentSize() {
            return this._contentSize;
        }

        public int getMetadataSize() {
            return this._metadataSize;
        }

        synchronized void store(Connection conn) throws SQLException {
            if (!this.stored()) {
                this.this$0.storeMetaData(conn, this._messageId, (StorableMessageMetaData)this._messageDataRef.getMetaData());
                this.this$0.addContent(conn, this._messageId, this._messageDataRef.getData() == null ? QpidByteBuffer.emptyQpidByteBuffer() : this._messageDataRef.getData());
                this.this$0.getLogger().debug("Storing message {} to store", (Object)this._messageId);
                this._messageDataRef.setSoft();
            }
        }

        synchronized CompletableFuture<Void> flushToStore() {
            if (this._messageDataRef != null && !this.stored()) {
                try (Connection conn = this.this$0.newConnection();){
                    this.store(conn);
                    conn.commit();
                    this.this$0.storedSizeChange(this.getContentSize());
                }
                catch (SQLException e) {
                    throw new StoreException("Failed to flow to disk", (Throwable)e);
                }
            }
            return CompletableFuture.completedFuture(null);
        }

        public synchronized void remove() {
            this.this$0.getLogger().debug("REMOVE called on message: {}", (Object)this._messageId);
            this.this$0.checkMessageStoreOpen();
            this.this$0._messages.remove(this);
            if (this.stored()) {
                this.this$0.removeMessageAsync(this._messageId);
                this.this$0.storedSizeChange(-this.getContentSize());
            }
            if (!this.this$0._messageDeleteListeners.isEmpty()) {
                for (MessageStore.MessageDeleteListener messageDeleteListener : this.this$0._messageDeleteListeners) {
                    messageDeleteListener.messageDeleted((StoredMessage)this);
                }
            }
            long bytesCleared = 0L;
            T metaData = this._messageDataRef.getMetaData();
            if (metaData != null) {
                bytesCleared += (long)this.getMetadataSize();
                metaData.dispose();
            }
            try (QpidByteBuffer data = this._messageDataRef.getData();){
                if (data != null) {
                    bytesCleared += (long)this.getContentSize();
                    this._messageDataRef.setData(null);
                }
            }
            this._messageDataRef = null;
            this.this$0._inMemorySize.addAndGet(-bytesCleared);
        }

        public synchronized boolean isInContentInMemory() {
            return this._messageDataRef != null && (this._messageDataRef.isHardRef() || this._messageDataRef.getData() != null);
        }

        public synchronized long getInMemorySize() {
            long size = 0L;
            if (this._messageDataRef != null) {
                if (this._messageDataRef.isHardRef()) {
                    size += (long)(this.getMetadataSize() + this.getContentSize());
                } else {
                    if (this._messageDataRef.getMetaData() != null) {
                        size += (long)this.getMetadataSize();
                    }
                    if (this._messageDataRef.getData() != null) {
                        size += (long)this.getContentSize();
                    }
                }
            }
            return size;
        }

        private boolean stored() {
            return this._messageDataRef != null && !this._messageDataRef.isHardRef();
        }

        public synchronized boolean flowToDisk() {
            this.flushToStore();
            if (this._messageDataRef != null && !this._messageDataRef.isHardRef()) {
                long bytesCleared = this._messageDataRef.clear(false);
                this.this$0._inMemorySize.addAndGet(-bytesCleared);
                this.this$0._bytesEvacuatedFromMemory.addAndGet(bytesCleared);
            }
            return true;
        }

        public synchronized void reallocate() {
            if (this._messageDataRef != null) {
                this._messageDataRef.reallocate();
            }
        }

        public synchronized void clear(boolean close) {
            if (this._messageDataRef != null) {
                this._messageDataRef.clear(close);
            }
        }

        public String toString() {
            return String.valueOf(this.getClass()) + "[messageId=" + this._messageId + "]";
        }
    }

    protected class JDBCTransaction
    implements Transaction {
        private final ConnectionWrapper _connWrapper;
        private int _storeSizeIncrease;
        private final List<Runnable> _preCommitActions = new ArrayList<Runnable>();
        private final List<Runnable> _postCommitActions = new ArrayList<Runnable>();
        private final Map<Long, List<TransactionLogResource>> _messagesToEnqueue = new HashMap<Long, List<TransactionLogResource>>();

        protected JDBCTransaction() {
            try {
                this._connWrapper = new ConnectionWrapper(AbstractJDBCMessageStore.this.newConnection());
            }
            catch (SQLException e) {
                throw new StoreException((Throwable)e);
            }
            this._preCommitActions.add(() -> AbstractJDBCMessageStore.this.enqueueMessages(this._connWrapper, this._messagesToEnqueue));
        }

        public MessageEnqueueRecord enqueueMessage(TransactionLogResource queue, EnqueueableMessage message) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            StoredMessage storedMessage = message.getStoredMessage();
            if (storedMessage instanceof StoredJDBCMessage) {
                this._preCommitActions.add(() -> {
                    try {
                        ((StoredJDBCMessage)storedMessage).store(this._connWrapper.getConnection());
                        this._storeSizeIncrease += storedMessage.getContentSize();
                    }
                    catch (SQLException e) {
                        throw new StoreException("Exception on enqueuing message into message store" + String.valueOf(AbstractJDBCMessageStore.this._messageId), (Throwable)e);
                    }
                });
            }
            List queues = this._messagesToEnqueue.computeIfAbsent(message.getMessageNumber(), messageId -> new ArrayList());
            queues.add(queue);
            return new JDBCEnqueueRecord(queue.getId(), message.getMessageNumber());
        }

        public void dequeueMessage(MessageEnqueueRecord enqueueRecord) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            AbstractJDBCMessageStore.this.dequeueMessage(this._connWrapper, enqueueRecord.getQueueId(), enqueueRecord.getMessageNumber());
        }

        public void commitTran() {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            this.doPreCommitActions();
            AbstractJDBCMessageStore.this.commitTran(this._connWrapper);
            AbstractJDBCMessageStore.this.storedSizeChange(this._storeSizeIncrease);
            this.doPostCommitActions();
        }

        public <X> CompletableFuture<X> commitTranAsync(X val) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            this.doPreCommitActions();
            CompletableFuture<X> futureResult = AbstractJDBCMessageStore.this.commitTranAsync(this._connWrapper, val);
            AbstractJDBCMessageStore.this.storedSizeChange(this._storeSizeIncrease);
            this.doPostCommitActions();
            return futureResult;
        }

        private void doPreCommitActions() {
            for (Runnable action : this._preCommitActions) {
                action.run();
            }
            this._preCommitActions.clear();
            this._messagesToEnqueue.clear();
        }

        private void doPostCommitActions() {
            if (!this._postCommitActions.isEmpty()) {
                for (Runnable action : this._postCommitActions) {
                    action.run();
                }
                this._postCommitActions.clear();
            }
        }

        public void abortTran() {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            this._preCommitActions.clear();
            this._messagesToEnqueue.clear();
            AbstractJDBCMessageStore.this.abortTran(this._connWrapper);
        }

        public void removeXid(Transaction.StoredXidRecord record) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            AbstractJDBCMessageStore.this.removeXid(this._connWrapper, record.getFormat(), record.getGlobalId(), record.getBranchId());
        }

        public Transaction.StoredXidRecord recordXid(long format, byte[] globalId, byte[] branchId, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            this._postCommitActions.addAll(AbstractJDBCMessageStore.this.recordXid(this._connWrapper, format, globalId, branchId, enqueues, dequeues));
            return new JDBCStoredXidRecord(format, globalId, branchId);
        }
    }

    private static final class ConnectionWrapper {
        private final Connection _connection;

        public ConnectionWrapper(Connection conn) {
            this._connection = conn;
        }

        public Connection getConnection() {
            return this._connection;
        }
    }

    private class JDBCMessageStoreReader
    implements MessageStore.MessageStoreReader {
        private JDBCMessageStoreReader() {
        }

        public StoredMessage<?> getMessage(long messageId) throws StoreException {
            StoredJDBCMessage<StorableMessageMetaData> storedJDBCMessage;
            block28: {
                AbstractJDBCMessageStore.this.checkMessageStoreOpen();
                Connection conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();
                try {
                    StoredJDBCMessage<StorableMessageMetaData> message;
                    block27: {
                        try (PreparedStatement stmt = conn.prepareStatement("SELECT message_id, meta_data FROM " + AbstractJDBCMessageStore.this.getMetaDataTableName() + " WHERE message_id = ?");){
                            stmt.setLong(1, messageId);
                            try (ResultSet rs = stmt.executeQuery();){
                                if (rs.next()) {
                                    try (InputStream blobAsInputStream = AbstractJDBCMessageStore.this.getBlobAsInputStream(rs, 2);){
                                        StorableMessageMetaData metaData = AbstractJDBCMessageStore.this.getStorableMessageMetaData(messageId, blobAsInputStream);
                                        message = AbstractJDBCMessageStore.this.createStoredJDBCMessage(messageId, metaData, true);
                                        break block27;
                                    }
                                }
                                message = null;
                            }
                        }
                    }
                    storedJDBCMessage = message;
                    if (conn == null) break block28;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | SQLException e) {
                        throw new StoreException("Error encountered when visiting messages", (Throwable)e);
                    }
                }
                conn.close();
            }
            return storedJDBCMessage;
        }

        public void close() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void visitMessages(MessageHandler handler) throws StoreException {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            while (AbstractJDBCMessageStore.this.isMessageRemovalScheduled()) {
            }
            try (Connection conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();
                 Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery("SELECT message_id, meta_data FROM " + AbstractJDBCMessageStore.this.getMetaDataTableName());){
                while (rs.next()) {
                    long messageId = rs.getLong(1);
                    InputStream dataAsInputStream = AbstractJDBCMessageStore.this.getBlobAsInputStream(rs, 2);
                    try {
                        StorableMessageMetaData metaData = AbstractJDBCMessageStore.this.getStorableMessageMetaData(messageId, dataAsInputStream);
                        StoredJDBCMessage<StorableMessageMetaData> message = AbstractJDBCMessageStore.this.createStoredJDBCMessage(messageId, metaData, true);
                        if (handler.handle(message)) continue;
                        return;
                    }
                    finally {
                        if (dataAsInputStream == null) continue;
                        dataAsInputStream.close();
                    }
                }
                return;
            }
            catch (IOException | SQLException e) {
                throw new StoreException("Error encountered when visiting messages", (Throwable)e);
            }
        }

        public void visitMessageInstances(TransactionLogResource queue, MessageInstanceHandler handler) throws StoreException {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            try (Connection conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();){
                CachingUUIDFactory uuidFactory = new CachingUUIDFactory();
                try (PreparedStatement stmt = conn.prepareStatement("SELECT queue_id, message_id FROM " + AbstractJDBCMessageStore.this.getQueueEntryTableName() + " WHERE queue_id = ? ORDER BY queue_id, message_id");){
                    stmt.setString(1, queue.getId().toString());
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            String id = rs.getString(1);
                            long messageId = rs.getLong(2);
                            UUID uuid = uuidFactory.createUuidFromString(id);
                            if (handler.handle((MessageEnqueueRecord)new JDBCEnqueueRecord(uuid, messageId))) continue;
                            break;
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new StoreException("Error encountered when visiting message instances", (Throwable)e);
            }
        }

        public void visitMessageInstances(MessageInstanceHandler handler) throws StoreException {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            try (Connection conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();){
                CachingUUIDFactory uuidFactory = new CachingUUIDFactory();
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT queue_id, message_id FROM " + AbstractJDBCMessageStore.this.getQueueEntryTableName() + " ORDER BY queue_id, message_id");){
                    while (rs.next()) {
                        String id = rs.getString(1);
                        long messageId = rs.getLong(2);
                        UUID queueId = uuidFactory.createUuidFromString(id);
                        if (handler.handle((MessageEnqueueRecord)new JDBCEnqueueRecord(queueId, messageId))) continue;
                        break;
                    }
                }
            }
            catch (SQLException e) {
                throw new StoreException("Error encountered when visiting message instances", (Throwable)e);
            }
        }

        public void visitDistributedTransactions(DistributedTransactionHandler handler) throws StoreException {
            AbstractJDBCMessageStore.this.checkMessageStoreOpen();
            try (Connection conn = AbstractJDBCMessageStore.this.newAutoCommitConnection();){
                ArrayList<Xid> xids = new ArrayList<Xid>();
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT format, global_id, branch_id FROM " + AbstractJDBCMessageStore.this.getXidTableName());){
                    while (rs.next()) {
                        long format = rs.getLong(1);
                        byte[] globalId = rs.getBytes(2);
                        byte[] branchId = rs.getBytes(3);
                        xids.add(new Xid(format, globalId, branchId));
                    }
                }
                for (Xid xid : xids) {
                    CachingUUIDFactory uuidFactory = new CachingUUIDFactory();
                    ArrayList<RecordImpl> enqueues = new ArrayList<RecordImpl>();
                    ArrayList dequeues = new ArrayList();
                    try (PreparedStatement pstmt = conn.prepareStatement("SELECT action_type, queue_id, message_id FROM " + AbstractJDBCMessageStore.this.getXidActionsTableName() + " WHERE format = ? and global_id = ? and branch_id = ?");){
                        pstmt.setLong(1, xid.getFormat());
                        pstmt.setBytes(2, xid.getGlobalId());
                        pstmt.setBytes(3, xid.getBranchId());
                        try (ResultSet rs = pstmt.executeQuery();){
                            while (rs.next()) {
                                String actionType = rs.getString(1);
                                UUID queueId = uuidFactory.createUuidFromString(rs.getString(2));
                                long messageId = rs.getLong(3);
                                RecordImpl record = new RecordImpl(queueId, messageId);
                                ArrayList<RecordImpl> records = "E".equals(actionType) ? enqueues : dequeues;
                                records.add(record);
                            }
                        }
                    }
                    if (handler.handle((Transaction.StoredXidRecord)new JDBCStoredXidRecord(xid.getFormat(), xid.getGlobalId(), xid.getBranchId()), (Transaction.EnqueueRecord[])enqueues.toArray(new RecordImpl[enqueues.size()]), (Transaction.DequeueRecord[])dequeues.toArray(new RecordImpl[dequeues.size()]))) continue;
                    break;
                }
            }
            catch (SQLException e) {
                throw new StoreException("Error encountered when visiting distributed transactions", (Throwable)e);
            }
        }
    }

    private static class JDBCEnqueueRecord
    implements MessageEnqueueRecord {
        private final UUID _queueId;
        private final long _messageNumber;

        public JDBCEnqueueRecord(UUID queueId, long messageNumber) {
            this._queueId = queueId;
            this._messageNumber = messageNumber;
        }

        public UUID getQueueId() {
            return this._queueId;
        }

        public long getMessageNumber() {
            return this._messageNumber;
        }
    }

    private static class MessageDataRef<T extends StorableMessageMetaData> {
        private volatile T _metaData;
        private volatile QpidByteBuffer _data;
        private volatile boolean _isHardRef;

        private MessageDataRef(T metaData, boolean isHardRef) {
            this(metaData, null, isHardRef);
        }

        private MessageDataRef(T metaData, QpidByteBuffer data, boolean isHardRef) {
            this._metaData = metaData;
            this._data = data;
            this._isHardRef = isHardRef;
        }

        public T getMetaData() {
            return this._metaData;
        }

        public QpidByteBuffer getData() {
            return this._data;
        }

        public void setData(QpidByteBuffer data) {
            this._data = data;
        }

        public boolean isHardRef() {
            return this._isHardRef;
        }

        public void setSoft() {
            this._isHardRef = false;
        }

        public void reallocate() {
            if (this._metaData != null) {
                this._metaData.reallocate();
            }
            this._data = QpidByteBuffer.reallocateIfNecessary((QpidByteBuffer)this._data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long clear(boolean close) {
            long bytesCleared = 0L;
            if (this._data != null && this._data != null) {
                bytesCleared += (long)this._data.remaining();
                this._data.dispose();
                this._data = null;
            }
            if (this._metaData != null) {
                bytesCleared += (long)this._metaData.getStorableSize();
                try {
                    if (close) {
                        this._metaData.dispose();
                    } else {
                        this._metaData.clearEncodedForm();
                    }
                }
                finally {
                    this._metaData = null;
                }
            }
            return bytesCleared;
        }
    }

    private static class JDBCStoredXidRecord
    implements Transaction.StoredXidRecord {
        private final long _format;
        private final byte[] _globalId;
        private final byte[] _branchId;

        public JDBCStoredXidRecord(long format, byte[] globalId, byte[] branchId) {
            this._format = format;
            this._globalId = globalId;
            this._branchId = branchId;
        }

        public long getFormat() {
            return this._format;
        }

        public byte[] getGlobalId() {
            return this._globalId;
        }

        public byte[] getBranchId() {
            return this._branchId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JDBCStoredXidRecord that = (JDBCStoredXidRecord)o;
            return this._format == that._format && Arrays.equals(this._globalId, that._globalId) && Arrays.equals(this._branchId, that._branchId);
        }

        public int hashCode() {
            int result = (int)(this._format ^ this._format >>> 32);
            result = 31 * result + Arrays.hashCode(this._globalId);
            result = 31 * result + Arrays.hashCode(this._branchId);
            return result;
        }
    }

    private static class RecordImpl
    implements Transaction.EnqueueRecord,
    Transaction.DequeueRecord,
    TransactionLogResource,
    EnqueueableMessage {
        private final JDBCEnqueueRecord _record;
        private final long _messageNumber;
        private final UUID _queueId;

        public RecordImpl(UUID queueId, long messageNumber) {
            this._messageNumber = messageNumber;
            this._queueId = queueId;
            this._record = new JDBCEnqueueRecord(queueId, messageNumber);
        }

        public MessageEnqueueRecord getEnqueueRecord() {
            return this._record;
        }

        public TransactionLogResource getResource() {
            return this;
        }

        public EnqueueableMessage getMessage() {
            return this;
        }

        public long getMessageNumber() {
            return this._messageNumber;
        }

        public boolean isPersistent() {
            return true;
        }

        public StoredMessage getStoredMessage() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this._queueId.toString();
        }

        public UUID getId() {
            return this._queueId;
        }

        public MessageDurability getMessageDurability() {
            return MessageDurability.DEFAULT;
        }
    }
}

