/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.producer;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.SendMessageRequest;
import apache.rocketmq.v2.SendMessageResponse;
import apache.rocketmq.v2.SendResultEntry;
import apache.rocketmq.v2.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.apache.rocketmq.client.java.exception.StatusChecker;
import org.apache.rocketmq.client.java.message.MessageIdCodec;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;

public class SendReceiptImpl
implements SendReceipt {
    private final MessageId messageId;
    private final String transactionId;
    private final MessageQueueImpl messageQueue;
    private final long offset;

    private SendReceiptImpl(MessageId messageId, String transactionId, MessageQueueImpl messageQueue, long offset) {
        this.messageId = messageId;
        this.transactionId = transactionId;
        this.messageQueue = messageQueue;
        this.offset = offset;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageQueueImpl getMessageQueue() {
        return this.messageQueue;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Endpoints getEndpoints() {
        return this.messageQueue.getBroker().getEndpoints();
    }

    public long getOffset() {
        return this.offset;
    }

    public static List<SendReceiptImpl> processResponseInvocation(MessageQueueImpl mq, SendMessageResponse response, RpcFuture<SendMessageRequest, SendMessageResponse> future) throws ClientException {
        Status status = response.getStatus();
        ArrayList<SendReceiptImpl> sendReceipts = new ArrayList<SendReceiptImpl>();
        List<SendResultEntry> entries = response.getEntriesList();
        Optional<Status> abnormalStatus = entries.stream().map(SendResultEntry::getStatus).filter(s2 -> !s2.getCode().equals(Code.OK)).findFirst();
        if (abnormalStatus.isPresent()) {
            status = abnormalStatus.get();
        }
        StatusChecker.check(status, future);
        for (SendResultEntry entry : entries) {
            MessageId messageId = MessageIdCodec.getInstance().decode(entry.getMessageId());
            String transactionId = entry.getTransactionId();
            long offset = entry.getOffset();
            SendReceiptImpl impl = new SendReceiptImpl(messageId, transactionId, mq, offset);
            sendReceipts.add(impl);
        }
        return sendReceipts;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("messageId", this.messageId).toString();
    }
}

