/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20;

import java.util.UUID;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.spi.UserManagement;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitUserManagement
implements UserManagement {
    public static final Name NAME_REP_AUTHORIZABLE_ID = NameFactoryImpl.getInstance().create("internal", "authorizableId");
    private static final Logger log = LoggerFactory.getLogger(JackrabbitUserManagement.class);

    @Override
    public boolean isAuthorizableNodeType(String ntName) {
        return ntName.equals("rep:Group") || ntName.equals("rep:User");
    }

    @Override
    public String getAuthorizablePath(Session session, String name) {
        try {
            UUID uuid = UUID.nameUUIDFromBytes(name.toLowerCase().getBytes("UTF-8"));
            return session.getNodeByIdentifier(uuid.toString()).getPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Deprecated
    public String getAuthorizableId(DocViewNode node) {
        DocViewProperty idProp = node.props.get("rep:authorizableId");
        if (idProp == null || idProp.isMulti) {
            return Text.unescapeIllegalJcrChars(node.name);
        }
        return idProp.values[0];
    }

    @Override
    public String getAuthorizableId(DocViewNode2 node) {
        DocViewProperty2 idProp = node.getProperty(NAME_REP_AUTHORIZABLE_ID).orElse(null);
        if (idProp == null || idProp.isMultiValue()) {
            return Text.unescapeIllegalJcrChars(node.getName().getLocalName());
        }
        return idProp.getStringValue().orElseThrow(() -> new IllegalStateException("No single value available for property 'rep:authorizableId'"));
    }

    @Override
    public void addMembers(Session session, String id, String[] membersUUID) {
        Authorizable auth;
        UserManager uMgr;
        if (!(session instanceof JackrabbitSession)) {
            log.warn("Unable to update membership. no jackrabbit session.");
            return;
        }
        try {
            uMgr = ((JackrabbitSession)session).getUserManager();
        }
        catch (RepositoryException e) {
            log.warn("Unable to update membership of {}. Error while retrieving user manager.", (Object)id, (Object)e);
            return;
        }
        try {
            auth = uMgr.getAuthorizable(id);
        }
        catch (RepositoryException e) {
            log.warn("Unable to update membership of {}. Error while retrieving authorizable.", (Object)id, (Object)e);
            return;
        }
        if (auth == null) {
            log.warn("Unable to update membership of {}. No such authorizable.", (Object)id);
            return;
        }
        if (!(auth instanceof Group)) {
            log.warn("Unable to update membership of {}. No a group.", (Object)id);
            return;
        }
        Group grp = (Group)auth;
        for (String uuid : membersUUID) {
            try {
                Node authNode = session.getNodeByIdentifier(uuid);
                String authPath = authNode.getPath();
                Authorizable member = uMgr.getAuthorizableByPath(authPath);
                if (member == null) {
                    log.warn("unable to add authorizable '{}' to group '{}'. Node at {} is not an authorizable.", (Object)uuid, (Object)authPath);
                    continue;
                }
                String memberId = member.getID();
                try {
                    if (grp.isDeclaredMember(member)) {
                        log.debug("ignoring to add authorizable '{}' to group '{}'. Already member.", (Object)memberId, (Object)id);
                        continue;
                    }
                    grp.addMember(member);
                    log.debug("added authorizable '{}' to group '{}'.", (Object)memberId, (Object)id);
                }
                catch (RepositoryException e) {
                    log.error("Error while adding authorizable '{}' to group '{}': {}", new Object[]{memberId, id, e});
                }
            }
            catch (ItemNotFoundException e) {
                log.warn("unable to add authorizable '{}' to group '{}'. No such node.", (Object)uuid, (Object)id);
            }
            catch (RepositoryException e) {
                log.warn("unable to add authorizable '{}' to group '{}'. Internal Error: {}", new Object[]{uuid, id, e});
            }
        }
    }
}

