/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.artifacts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.osgi.framework.Version;

public class EmbeddedBundle {
    private final String bundleSymbolicName;
    private final Version version;
    private final URL source;

    public EmbeddedBundle(URL source) throws IOException {
        try (JarInputStream jarInput = new JarInputStream(source.openStream());){
            Manifest manifest = jarInput.getManifest();
            this.version = new Version(manifest.getMainAttributes().getValue("Bundle-Version"));
            this.bundleSymbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        }
        this.source = source;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public InputStream openInputStream() throws IOException {
        return this.source.openStream();
    }
}

