/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import org.apache.jackrabbit.core.config.ConfigurationException;

public class DataSourceConfig {
    public static final String DRIVER = "driver";
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String DB_TYPE = "databaseType";
    public static final String VALIDATION_QUERY = "validationQuery";
    public static final String MAX_POOL_SIZE = "maxPoolSize";
    private final List<DataSourceDefinition> defs = new ArrayList<DataSourceDefinition>();

    public void addDataSourceDefinition(String name, Properties props) throws ConfigurationException {
        DataSourceDefinition def = new DataSourceDefinition(name, props);
        for (DataSourceDefinition existing : this.defs) {
            if (!existing.getLogicalName().equals(def.getLogicalName())) continue;
            throw new ConfigurationException("Duplicate logicalName for a DataSource: " + def.getLogicalName());
        }
        this.defs.add(def);
    }

    public List<DataSourceDefinition> getDefinitions() {
        return Collections.unmodifiableList(this.defs);
    }

    public static final class DataSourceDefinition {
        private static final List<String> allPropNames = Arrays.asList("driver", "url", "user", "password", "databaseType", "validationQuery", "maxPoolSize");
        private static final List<String> allJndiPropNames = Arrays.asList("driver", "url", "user", "password", "databaseType");
        private final String logicalName;
        private final String driver;
        private final String url;
        private final String user;
        private final String password;
        private final String dbType;
        private final String validationQuery;
        private final int maxPoolSize;

        public DataSourceDefinition(String name, Properties props) throws ConfigurationException {
            this.logicalName = name;
            this.driver = props.getProperty(DataSourceConfig.DRIVER);
            this.url = props.getProperty(DataSourceConfig.URL);
            this.user = props.getProperty(DataSourceConfig.USER);
            this.password = props.getProperty(DataSourceConfig.PASSWORD);
            this.dbType = props.getProperty(DataSourceConfig.DB_TYPE);
            this.validationQuery = props.getProperty(DataSourceConfig.VALIDATION_QUERY);
            try {
                this.maxPoolSize = Integer.parseInt(props.getProperty(DataSourceConfig.MAX_POOL_SIZE, "-1"));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("failed to parse maxPoolSize property for DataSource " + this.logicalName);
            }
            this.verify(props);
        }

        private void verify(Properties props) throws ConfigurationException {
            if (this.logicalName == null || "".equals(this.logicalName.trim())) {
                throw new ConfigurationException("DataSource logical name must not be null or empty");
            }
            if (this.driver == null || "".equals(this.driver)) {
                throw new ConfigurationException("DataSource driver must not be null or empty");
            }
            if (this.url == null || "".equals(this.url)) {
                throw new ConfigurationException("DataSource URL must not be null or empty");
            }
            if (this.dbType == null || "".equals(this.dbType)) {
                throw new ConfigurationException("DataSource databaseType must not be null or empty");
            }
            for (Object propName : props.keySet()) {
                if (allPropNames.contains((String)propName)) continue;
                throw new ConfigurationException("Unknown DataSource property: " + String.valueOf(propName));
            }
            if (this.isJndiConfig()) {
                for (Object propName : props.keySet()) {
                    if (allJndiPropNames.contains((String)propName)) continue;
                    throw new ConfigurationException("Property " + String.valueOf(propName) + " is not allowed for a DataSource obtained through JNDI, DataSource logicalName = " + this.logicalName);
                }
            }
        }

        private boolean isJndiConfig() throws ConfigurationException {
            Class<?> driverClass = null;
            try {
                if (this.driver.length() > 0) {
                    driverClass = Class.forName(this.driver);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Could not load JDBC driver class " + this.driver, e);
            }
            return driverClass != null && Context.class.isAssignableFrom(driverClass);
        }

        public String getLogicalName() {
            return this.logicalName;
        }

        public String getDriver() {
            return this.driver;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUser() {
            return this.user;
        }

        public String getDbType() {
            return this.dbType;
        }

        public String getPassword() {
            return this.password;
        }

        public String getValidationQuery() {
            return this.validationQuery;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }
    }
}

