/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.serializer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.json.BlobDeserializer;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.OakFileDataStore;
import org.apache.jackrabbit.oak.plugins.memory.AbstractBlob;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSBlobSerializer
extends BlobSerializer
implements BlobDeserializer,
Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERROR_MARKER = "*ERROR*-";
    private final File dir;
    private final int maxInlineSize;
    private final DataStoreBlobStore dataStore;

    public FSBlobSerializer(File dir) {
        this(dir, 4096);
    }

    public FSBlobSerializer(File dir, int maxInlineSize) {
        this.dir = dir;
        this.maxInlineSize = maxInlineSize;
        this.dataStore = this.createDataStore();
    }

    @Override
    public String serialize(Blob blob) {
        String string;
        block8: {
            InputStream is = blob.getNewStream();
            try {
                string = this.dataStore.writeBlob(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.log.warn("Error occurred while serializing Blob with id {}", (Object)blob.getContentIdentity(), (Object)e);
                    return String.format("%s%s", ERROR_MARKER, blob.getContentIdentity());
                }
            }
            is.close();
        }
        return string;
    }

    private DataStoreBlobStore createDataStore() {
        OakFileDataStore fds = new OakFileDataStore();
        fds.setPath(this.dir.getAbsolutePath());
        fds.setMinRecordLength(this.maxInlineSize);
        fds.init(null);
        return new DataStoreBlobStore(fds);
    }

    @Override
    public Blob deserialize(String value) {
        if (this.errorBlob(value)) {
            return new ErrorBlob(value);
        }
        return new BlobStoreBlob(this.dataStore, value);
    }

    private boolean errorBlob(String value) {
        return value.startsWith(ERROR_MARKER);
    }

    @Override
    public void close() throws IOException {
        if (this.dataStore != null) {
            try {
                this.dataStore.close();
            }
            catch (DataStoreException e) {
                throw new IOException((Throwable)((Object)e));
            }
        }
    }

    private static final class ErrorBlob
    extends AbstractBlob {
        private final String id;

        public ErrorBlob(String id) {
            this.id = id.substring(FSBlobSerializer.ERROR_MARKER.length());
        }

        @Override
        public String getContentIdentity() {
            return this.id;
        }

        @Override
        @NotNull
        public InputStream getNewStream() {
            throw this.createError();
        }

        @Override
        public long length() {
            throw this.createError();
        }

        private RuntimeException createError() {
            return new RuntimeException("Blob with id [" + this.id + "] threw error while serializing");
        }
    }
}

