/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCheckpointCreator
implements Runnable {
    public static final String PROP_ASYNC_NAME = "oak.checkpoint.async";
    private final String name;
    private final long checkpointLifetimeInSeconds;
    private final long minConcurrentCheckpoints;
    private final long maxConcurrentCheckpoints;
    private final NodeStore store;
    public static final String CHECKPOINT_CREATOR_KEY = "creator";
    public static final String CHECKPOINT_CREATED_KEY = "created";
    public static final String CHECKPOINT_CREATED_TIMESTAMP_KEY = "created-epoch";
    public static final String CHECKPOINT_THREAD_KEY = "thread";
    public static final String CHECKPOINT_NAME_KEY = "name";
    private static final Logger log = LoggerFactory.getLogger(AsyncCheckpointCreator.class);

    public AsyncCheckpointCreator(@NotNull NodeStore store, @NotNull String name, long checkpointLifetimeInSeconds, long minConcurrentCheckpoints, long maxConcurrentCheckpoints) {
        this.store = store;
        this.name = name;
        this.checkpointLifetimeInSeconds = checkpointLifetimeInSeconds;
        this.minConcurrentCheckpoints = minConcurrentCheckpoints;
        if (maxConcurrentCheckpoints <= minConcurrentCheckpoints) {
            log.warn("[{}] Max concurrent checkpoints is less than or equal to min concurrent checkpoints. Setting max concurrent checkpoints to min concurrent checkpoints + 1.", (Object)this.name);
            this.maxConcurrentCheckpoints = minConcurrentCheckpoints + 1L;
        } else {
            this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
        }
    }

    public String getName() {
        return this.name;
    }

    protected long getCheckpointLifetimeInSeconds() {
        return this.checkpointLifetimeInSeconds;
    }

    protected long getMinConcurrentCheckpoints() {
        return this.minConcurrentCheckpoints;
    }

    protected long getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    @Override
    public void run() {
        Map<String, Map<String, String>> filteredCheckpointMap = IndexUtils.getFilteredCheckpoints(this.store, entry -> this.name.equals(((Map)entry.getValue()).get(CHECKPOINT_NAME_KEY)));
        if ((long)filteredCheckpointMap.size() >= this.maxConcurrentCheckpoints) {
            log.warn("[{}] Skipping checkpoint creation as the number of concurrent checkpoints is already at max limit {}", (Object)this.name, (Object)this.maxConcurrentCheckpoints);
        } else {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            String creationTimeStamp = String.valueOf(cal.getTimeInMillis());
            String creationTimeISOFormat = ISO8601.format(cal);
            String checkpoint = this.store.checkpoint(this.checkpointLifetimeInSeconds * 1000L, Map.of(CHECKPOINT_CREATOR_KEY, AsyncCheckpointCreator.class.getSimpleName(), CHECKPOINT_CREATED_KEY, creationTimeISOFormat, CHECKPOINT_CREATED_TIMESTAMP_KEY, creationTimeStamp, CHECKPOINT_THREAD_KEY, Thread.currentThread().getName(), CHECKPOINT_NAME_KEY, this.name));
            log.info("[{}] Created checkpoint {} with creation time {}", new Object[]{this.name, checkpoint, creationTimeISOFormat});
        }
        Set<String> sortedCheckpointSet = IndexUtils.getSortedCheckpointMap(IndexUtils.getFilteredCheckpoints(this.store, entry -> this.name.equals(((Map)entry.getValue()).get(CHECKPOINT_NAME_KEY))), CHECKPOINT_CREATED_TIMESTAMP_KEY).keySet();
        int counter = sortedCheckpointSet.size();
        for (String cp : sortedCheckpointSet) {
            if ((long)counter <= this.minConcurrentCheckpoints) break;
            if (this.store.release(cp)) {
                log.info("[{}] Deleted checkpoint {}", (Object)this.name, (Object)cp);
            } else {
                log.warn("[{}] Unable to delete checkpoint {}. Removal will be attempted again in next run.", (Object)this.name, (Object)cp);
            }
            --counter;
        }
    }
}

