/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.cursor;

import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.plugins.index.cursor.AbstractCursor;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;

class ConcatCursor
extends AbstractCursor {
    private final HashSet<String> seen = new HashSet();
    private final List<Cursor> cursors;
    private final QueryLimits settings;
    private boolean init;
    private boolean closed;
    private Cursor currentCursor;
    private int cursorListIndex;
    private IndexRow current;

    ConcatCursor(List<Cursor> cursors, QueryLimits settings) {
        this.cursors = cursors;
        this.settings = settings;
        this.nextCursor();
    }

    private void nextCursor() {
        if (this.cursorListIndex >= this.cursors.size()) {
            this.init = true;
            this.closed = true;
        } else {
            this.currentCursor = this.cursors.get(this.cursorListIndex++);
        }
    }

    @Override
    public IndexRow next() {
        if (this.closed) {
            throw new IllegalStateException("This cursor is closed");
        }
        if (!this.init) {
            this.fetchNext();
            this.init = true;
        }
        IndexRow result = this.current;
        this.init = false;
        return result;
    }

    @Override
    public boolean hasNext() {
        if (!this.closed && !this.init) {
            this.fetchNext();
            this.init = true;
        }
        return !this.closed;
    }

    private void fetchNext() {
        String p;
        IndexRow c;
        while (true) {
            if (!this.currentCursor.hasNext()) {
                this.nextCursor();
                if (!this.closed) continue;
                return;
            }
            c = this.currentCursor.next();
            p = c.getPath();
            if (!this.seen.contains(p)) break;
        }
        this.current = c;
        this.markSeen(p);
    }

    private void markSeen(String path) {
        this.seen.add(path);
        FilterIterators.checkMemoryLimit(this.seen.size(), this.settings);
    }

    @Override
    public long getSize(Result.SizePrecision precision, long max) {
        long total = 0L;
        for (Cursor c : this.cursors) {
            long t = c.getSize(precision, max);
            if (t < 0L) {
                return -1L;
            }
            total = QueryImpl.saturatedAdd(total, t);
        }
        return total;
    }
}

