/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.ArrayList;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;

public class ResultImpl
implements Result {
    protected final Query query;

    ResultImpl(Query query) {
        this.query = query;
    }

    @Override
    public String[] getColumnNames() {
        ColumnImpl[] cols = this.query.getColumns();
        String[] names = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            names[i] = cols[i].getColumnName();
        }
        return names;
    }

    @Override
    public String[] getColumnSelectorNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ColumnImpl c : this.query.getColumns()) {
            String name;
            SelectorImpl selector = c.getSelector();
            String string = name = selector == null ? null : selector.getSelectorName();
            if (list.contains(name)) continue;
            list.add(name);
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getSelectorNames() {
        return this.query.getSelectorNames();
    }

    @Override
    public Iterable<? extends ResultRow> getRows() {
        return this.query::getRows;
    }

    @Override
    public long getSize() {
        return this.query.getSize();
    }

    @Override
    public long getSize(Result.SizePrecision precision, long max) {
        return this.query.getSize(precision, max);
    }
}

