/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.internal;

import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.impl.RootProviderService;
import org.apache.jackrabbit.oak.plugins.tree.impl.TreeProviderService;
import org.apache.jackrabbit.oak.security.authentication.AuthenticationConfigurationImpl;
import org.apache.jackrabbit.oak.security.authentication.token.TokenConfigurationImpl;
import org.apache.jackrabbit.oak.security.authorization.AuthorizationConfigurationImpl;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl;
import org.apache.jackrabbit.oak.security.internal.ConfigurationInitializer;
import org.apache.jackrabbit.oak.security.internal.InternalSecurityProvider;
import org.apache.jackrabbit.oak.security.principal.PrincipalConfigurationImpl;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeConfigurationImpl;
import org.apache.jackrabbit.oak.security.user.UserConfigurationImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.CompositeTokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.CompositePrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableNodeName;
import org.apache.jackrabbit.oak.spi.security.user.UserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;

public final class SecurityProviderBuilder {
    private Whiteboard whiteboard;
    private RootProvider rootProvider;
    private TreeProvider treeProvider;
    private ConfigurationParameters authenticationParams = ConfigurationParameters.EMPTY;
    private AuthenticationConfiguration authenticationConfiguration;
    private ConfigurationParameters privilegeParams = ConfigurationParameters.EMPTY;
    private PrivilegeConfiguration privilegeConfiguration;
    private ConfigurationParameters userParams = ConfigurationParameters.EMPTY;
    private UserConfiguration userConfiguration;
    private ConfigurationParameters authorizationParams = ConfigurationParameters.EMPTY;
    private AuthorizationConfiguration authorizationConfiguration;
    private ConfigurationParameters principalParams = ConfigurationParameters.EMPTY;
    private PrincipalConfiguration principalConfiguration;
    private ConfigurationParameters tokenParams = ConfigurationParameters.EMPTY;
    private TokenConfiguration tokenConfiguration;
    private ConfigurationParameters configuration = ConfigurationParameters.EMPTY;

    @NotNull
    public static SecurityProviderBuilder newBuilder() {
        return new SecurityProviderBuilder();
    }

    private SecurityProviderBuilder() {
    }

    public SecurityProviderBuilder with(@NotNull ConfigurationParameters configuration) {
        this.configuration = configuration;
        this.authenticationParams = configuration.getConfigValue("org.apache.jackrabbit.oak.authentication", ConfigurationParameters.EMPTY);
        this.privilegeParams = configuration.getConfigValue("org.apache.jackrabbit.oak.privilege", ConfigurationParameters.EMPTY);
        if (configuration.contains("org.apache.jackrabbit.oak.user")) {
            this.userParams = configuration.getConfigValue("org.apache.jackrabbit.oak.user", ConfigurationParameters.EMPTY);
        } else {
            DefaultAuthorizableActionProvider authorizableActionProvider = new DefaultAuthorizableActionProvider();
            AuthorizableNodeName authorizableNodeName = AuthorizableNodeName.DEFAULT;
            UserAuthenticationFactory userAuthenticationFactory = UserConfigurationImpl.getDefaultAuthenticationFactory();
            this.userParams = ConfigurationParameters.of(ConfigurationParameters.of("authorizableActionProvider", authorizableActionProvider), ConfigurationParameters.of("authorizableNodeName", authorizableNodeName), ConfigurationParameters.of("userAuthenticationFactory", userAuthenticationFactory));
        }
        if (configuration.contains("org.apache.jackrabbit.oak.authorization")) {
            this.authorizationParams = configuration.getConfigValue("org.apache.jackrabbit.oak.authorization", ConfigurationParameters.EMPTY);
        } else {
            RestrictionProviderImpl restrictionProvider = new RestrictionProviderImpl();
            this.authorizationParams = ConfigurationParameters.of("restrictionProvider", restrictionProvider);
        }
        this.principalParams = configuration.getConfigValue("org.apache.jackrabbit.oak.principal", ConfigurationParameters.EMPTY);
        this.tokenParams = configuration.getConfigValue("org.apache.jackrabbit.oak.authentication.token", ConfigurationParameters.EMPTY);
        return this;
    }

    public SecurityProviderBuilder with(@NotNull AuthenticationConfiguration authenticationConfiguration, @NotNull ConfigurationParameters authenticationParams, @NotNull PrivilegeConfiguration privilegeConfiguration, @NotNull ConfigurationParameters privilegeParams, @NotNull UserConfiguration userConfiguration, @NotNull ConfigurationParameters userParams, @NotNull AuthorizationConfiguration authorizationConfiguration, @NotNull ConfigurationParameters authorizationParams, @NotNull PrincipalConfiguration principalConfiguration, @NotNull ConfigurationParameters principalParams, @NotNull TokenConfiguration tokenConfiguration, @NotNull ConfigurationParameters tokenParams) {
        this.authenticationConfiguration = authenticationConfiguration;
        this.authenticationParams = authenticationParams;
        this.privilegeConfiguration = privilegeConfiguration;
        this.privilegeParams = privilegeParams;
        this.userConfiguration = userConfiguration;
        this.userParams = userParams;
        this.authorizationConfiguration = authorizationConfiguration;
        this.authorizationParams = authorizationParams;
        this.principalConfiguration = principalConfiguration;
        this.principalParams = principalParams;
        this.tokenConfiguration = tokenConfiguration;
        this.tokenParams = tokenParams;
        return this;
    }

    public SecurityProvider build() {
        InternalSecurityProvider securityProvider = new InternalSecurityProvider();
        if (this.rootProvider == null) {
            this.rootProvider = new RootProviderService();
        }
        if (this.treeProvider == null) {
            this.treeProvider = new TreeProviderService();
        }
        if (this.authenticationConfiguration == null) {
            this.authenticationConfiguration = new AuthenticationConfigurationImpl();
        }
        securityProvider.setAuthenticationConfiguration(ConfigurationInitializer.initializeConfiguration(this.authenticationConfiguration, securityProvider, this.authenticationParams, this.rootProvider, this.treeProvider));
        if (this.privilegeConfiguration == null) {
            this.privilegeConfiguration = new PrivilegeConfigurationImpl();
        }
        securityProvider.setPrivilegeConfiguration(ConfigurationInitializer.initializeConfiguration(this.privilegeConfiguration, securityProvider, this.privilegeParams, this.rootProvider, this.treeProvider));
        if (this.userConfiguration == null) {
            this.userConfiguration = new UserConfigurationImpl();
        }
        securityProvider.setUserConfiguration(ConfigurationInitializer.initializeConfiguration(this.userConfiguration, securityProvider, this.userParams, this.rootProvider, this.treeProvider));
        if (this.authorizationConfiguration == null) {
            CompositeAuthorizationConfiguration ac = new CompositeAuthorizationConfiguration();
            ac.withCompositionType(this.configuration.getConfigValue("authorizationCompositionType", CompositeAuthorizationConfiguration.CompositionType.AND.toString()));
            ac.setDefaultConfig((AuthorizationConfiguration)ConfigurationInitializer.initializeConfiguration(new AuthorizationConfigurationImpl(), securityProvider, this.rootProvider, this.treeProvider));
            this.authorizationConfiguration = ac;
        }
        if (this.authorizationConfiguration instanceof CompositeAuthorizationConfiguration) {
            ConfigurationInitializer.initializeConfigurations((CompositeAuthorizationConfiguration)this.authorizationConfiguration, securityProvider, this.authorizationParams, this.rootProvider, this.treeProvider);
        } else {
            ConfigurationInitializer.initializeConfiguration(this.authorizationConfiguration, securityProvider, this.authorizationParams, this.rootProvider, this.treeProvider);
        }
        securityProvider.setAuthorizationConfiguration(this.authorizationConfiguration);
        if (this.principalConfiguration == null) {
            CompositePrincipalConfiguration pc = new CompositePrincipalConfiguration();
            pc.setDefaultConfig((PrincipalConfiguration)ConfigurationInitializer.initializeConfiguration(new PrincipalConfigurationImpl(), securityProvider, this.rootProvider, this.treeProvider));
            this.principalConfiguration = pc;
        }
        if (this.principalConfiguration instanceof CompositePrincipalConfiguration) {
            ConfigurationInitializer.initializeConfigurations((CompositePrincipalConfiguration)this.principalConfiguration, securityProvider, this.principalParams, this.rootProvider, this.treeProvider);
        } else {
            ConfigurationInitializer.initializeConfiguration(this.principalConfiguration, securityProvider, this.principalParams, this.rootProvider, this.treeProvider);
        }
        securityProvider.setPrincipalConfiguration(this.principalConfiguration);
        if (this.tokenConfiguration == null) {
            CompositeTokenConfiguration tc = new CompositeTokenConfiguration();
            tc.setDefaultConfig((TokenConfiguration)ConfigurationInitializer.initializeConfiguration(new TokenConfigurationImpl(), securityProvider, this.rootProvider, this.treeProvider));
            this.tokenConfiguration = tc;
        }
        if (this.tokenConfiguration instanceof CompositeTokenConfiguration) {
            ConfigurationInitializer.initializeConfigurations((CompositeTokenConfiguration)this.tokenConfiguration, securityProvider, this.tokenParams, this.rootProvider, this.treeProvider);
        } else {
            ConfigurationInitializer.initializeConfiguration(this.tokenConfiguration, securityProvider, this.tokenParams, this.rootProvider, this.treeProvider);
        }
        securityProvider.setTokenConfiguration(this.tokenConfiguration);
        if (this.whiteboard != null) {
            securityProvider.setWhiteboard(this.whiteboard);
        }
        return securityProvider;
    }

    public SecurityProviderBuilder withWhiteboard(@NotNull Whiteboard whiteboard) {
        this.whiteboard = whiteboard;
        return this;
    }

    public SecurityProviderBuilder withRootProvider(@NotNull RootProvider rootProvider) {
        this.rootProvider = rootProvider;
        return this;
    }

    public SecurityProviderBuilder withTreeProvider(@NotNull TreeProvider treeProvider) {
        this.treeProvider = treeProvider;
        return this;
    }
}

