/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeEditor
implements Editor {
    private final List<? extends Editor> editors;

    @Nullable
    public static Editor compose(@NotNull List<? extends Editor> editors) {
        switch (editors.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return editors.get(0);
            }
        }
        return new CompositeEditor(editors);
    }

    public CompositeEditor(List<? extends Editor> editors) {
        this.editors = editors;
    }

    public CompositeEditor(Editor ... editors) {
        this(List.of(editors));
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.enter(before, after);
        }
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        for (Editor editor : this.editors) {
            editor.leave(before, after);
        }
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        for (int i = 0; i < this.editors.size(); ++i) {
            this.editors.get(i).propertyAdded(after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        for (int i = 0; i < this.editors.size(); ++i) {
            this.editors.get(i).propertyChanged(before, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        for (int i = 0; i < this.editors.size(); ++i) {
            this.editors.get(i).propertyDeleted(before);
        }
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        ArrayList<Editor> list = new ArrayList<Editor>(this.editors.size());
        for (int i = 0; i < this.editors.size(); ++i) {
            Editor child = this.editors.get(i).childNodeAdded(name, after);
            if (child == null) continue;
            list.add(child);
        }
        return CompositeEditor.compose(list);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        ArrayList<Editor> list = new ArrayList<Editor>(this.editors.size());
        for (int i = 0; i < this.editors.size(); ++i) {
            Editor child = this.editors.get(i).childNodeChanged(name, before, after);
            if (child == null) continue;
            list.add(child);
        }
        return CompositeEditor.compose(list);
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        ArrayList<Editor> list = new ArrayList<Editor>(this.editors.size());
        for (int i = 0; i < this.editors.size(); ++i) {
            Editor child = this.editors.get(i).childNodeDeleted(name, before);
            if (child == null) continue;
            list.add(child);
        }
        return CompositeEditor.compose(list);
    }
}

