/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibleValidator
implements Validator {
    private final Validator validator;
    private final boolean hideNodes;
    private final boolean hideProperties;

    public VisibleValidator(@NotNull Validator validator, boolean hideNodes, boolean hideProperties) {
        this.validator = validator;
        this.hideNodes = hideNodes;
        this.hideProperties = hideProperties;
    }

    private Validator getValidator(@Nullable Validator validator) {
        if (validator == null) {
            return null;
        }
        if (validator instanceof VisibleValidator) {
            return validator;
        }
        return new VisibleValidator(validator, this.hideNodes, this.hideProperties);
    }

    private boolean isVisibleNode(String name) {
        if (this.hideNodes) {
            return !NodeStateUtils.isHidden(name);
        }
        return true;
    }

    private boolean isVisibleProperty(String name) {
        if (this.hideProperties) {
            return !NodeStateUtils.isHidden(name);
        }
        return true;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.validator.enter(before, after);
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        this.validator.leave(before, after);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (this.isVisibleProperty(after.getName())) {
            this.validator.propertyAdded(after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (this.isVisibleProperty(after.getName())) {
            this.validator.propertyChanged(before, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        if (this.isVisibleProperty(before.getName())) {
            this.validator.propertyDeleted(before);
        }
    }

    @Override
    @Nullable
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (this.isVisibleNode(name)) {
            return this.getValidator(this.validator.childNodeAdded(name, after));
        }
        return null;
    }

    @Override
    @Nullable
    public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        if (this.isVisibleNode(name)) {
            return this.getValidator(this.validator.childNodeChanged(name, before, after));
        }
        return null;
    }

    @Override
    @Nullable
    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (this.isVisibleNode(name)) {
            return this.getValidator(this.validator.childNodeDeleted(name, before));
        }
        return null;
    }
}

