/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security;

import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationBase
extends SecurityConfiguration.Default {
    private SecurityProvider securityProvider;
    private ConfigurationParameters config = ConfigurationParameters.EMPTY;
    private RootProvider rootProvider;
    private TreeProvider treeProvider;

    public ConfigurationBase() {
    }

    public ConfigurationBase(@NotNull SecurityProvider securityProvider, @NotNull ConfigurationParameters config) {
        this.securityProvider = securityProvider;
        this.config = config;
    }

    @NotNull
    public SecurityProvider getSecurityProvider() {
        if (this.securityProvider == null) {
            throw new IllegalStateException();
        }
        return this.securityProvider;
    }

    public void setSecurityProvider(@NotNull SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public void setParameters(@NotNull ConfigurationParameters config) {
        this.config = config;
    }

    public void setRootProvider(@NotNull RootProvider rootProvider) {
        this.rootProvider = rootProvider;
    }

    @NotNull
    public RootProvider getRootProvider() {
        if (this.rootProvider == null) {
            throw new IllegalStateException("RootProvider missing.");
        }
        return this.rootProvider;
    }

    public void setTreeProvider(@NotNull TreeProvider treeProvider) {
        this.treeProvider = treeProvider;
    }

    @NotNull
    public TreeProvider getTreeProvider() {
        if (this.treeProvider == null) {
            throw new IllegalStateException("TreeProvider missing.");
        }
        return this.treeProvider;
    }

    @Override
    @NotNull
    public ConfigurationParameters getParameters() {
        return this.config;
    }
}

