/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.saml.idp.metadata;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.SAML2IdPEntityTO;
import org.apache.syncope.common.rest.api.service.SAML2IdPEntityService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.services.BaseRegisteredService;
import org.apereo.cas.support.saml.idp.metadata.generator.BaseSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASamlIdPMetadataGenerator
extends BaseSamlIdPMetadataGenerator {
    protected static final Logger LOG = LoggerFactory.getLogger(WASamlIdPMetadataGenerator.class);
    protected final WARestClient waRestClient;

    public WASamlIdPMetadataGenerator(SamlIdPMetadataGeneratorConfigurationContext samlIdPMetadataGeneratorConfigurationContext, WARestClient waRestClient) {
        super(samlIdPMetadataGeneratorConfigurationContext);
        this.waRestClient = waRestClient;
    }

    protected SamlIdPMetadataDocument finalizeMetadataDocument(SamlIdPMetadataDocument doc, Optional<SamlRegisteredService> registeredService) throws Exception {
        doc.setAppliesTo(registeredService.map(BaseRegisteredService::getName).orElse("Syncope"));
        LOG.info("Setting new SAML2 IdP metadata document for {}", (Object)doc.getAppliesTo());
        SAML2IdPEntityTO entityTO = (SAML2IdPEntityTO)((SAML2IdPEntityTO.Builder)new SAML2IdPEntityTO.Builder().key(doc.getAppliesTo())).metadata(Base64.getEncoder().encodeToString(doc.getMetadata().getBytes(StandardCharsets.UTF_8))).build();
        if (doc.getSigningKey() != null) {
            entityTO.setSigningKey(Base64.getEncoder().encodeToString(doc.getSigningKey().getBytes(StandardCharsets.UTF_8)));
        }
        if (doc.getSigningCertificate() != null) {
            entityTO.setSigningCertificate(Base64.getEncoder().encodeToString(doc.getSigningCertificate().getBytes(StandardCharsets.UTF_8)));
        }
        if (doc.getEncryptionKey() != null) {
            entityTO.setEncryptionKey(Base64.getEncoder().encodeToString(doc.getEncryptionKey().getBytes(StandardCharsets.UTF_8)));
        }
        if (doc.getEncryptionCertificate() != null) {
            entityTO.setEncryptionCertificate(Base64.getEncoder().encodeToString(doc.getEncryptionCertificate().getBytes(StandardCharsets.UTF_8)));
        }
        ((SAML2IdPEntityService)this.waRestClient.getService(SAML2IdPEntityService.class)).set(entityTO);
        return doc;
    }

    public Pair<String, String> buildSelfSignedEncryptionCert(Optional<SamlRegisteredService> registeredService) throws Exception {
        return this.generateCertificateAndKey();
    }

    public Pair<String, String> buildSelfSignedSigningCert(Optional<SamlRegisteredService> registeredService) throws Exception {
        return this.generateCertificateAndKey();
    }
}

