/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.service;

import com.microsoft.graph.directoryobjects.item.getmembergroups.GetMemberGroupsPostRequestBody;
import com.microsoft.graph.directoryobjects.item.getmemberobjects.GetMemberObjectsPostRequestBody;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.DirectoryObjectCollectionResponse;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.GroupCollectionResponse;
import com.microsoft.graph.models.ReferenceCreate;
import com.microsoft.graph.models.SubscribedSku;
import com.microsoft.graph.models.SubscribedSkuCollectionResponse;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserCollectionResponse;
import com.microsoft.graph.users.item.assignlicense.AssignLicensePostRequestBody;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.azure.AzureConnectorConfiguration;
import net.tirasa.connid.bundles.azure.service.AzureService;
import net.tirasa.connid.bundles.azure.utils.AzureFilter;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;
import org.identityconnectors.common.logging.Log;

public class AzureClient
extends AzureService {
    private static final Log LOG = Log.getLog(AzureClient.class);

    public AzureClient(AzureConnectorConfiguration config) {
        super(config);
    }

    public AzureClient getAuthenticated() {
        this.checkAuth();
        return this;
    }

    public List<User> getAllUsers() {
        LOG.ok("Get all users", new Object[0]);
        UserCollectionResponse result = this.getGraphServiceClient().users().get(req -> {
            req.queryParameters.select = this.config.getUserAttributesToGet();
            req.queryParameters.orderby = new String[]{"displayName"};
        });
        return Optional.ofNullable(result).map(UserCollectionResponse::getValue).orElse(Collections.emptyList());
    }

    public UserCollectionResponse getAllUsers(int pageSize) {
        LOG.ok("Get all users with page size {0}", new Object[]{pageSize});
        return this.getGraphServiceClient().users().get(req -> {
            req.queryParameters.select = this.config.getUserAttributesToGet();
            req.queryParameters.orderby = new String[]{"displayName"};
            req.queryParameters.top = pageSize;
        });
    }

    public UserCollectionResponse getAllUsersNextPage(String odataNextLink) {
        LOG.ok("Get all users next page {0}", new Object[]{odataNextLink});
        return this.getGraphServiceClient().users().withUrl(odataNextLink).get();
    }

    public User getUser(String userId) {
        LOG.ok("Getting user {0}", new Object[]{userId});
        return this.getGraphServiceClient().users().byUserId(userId).get(req -> {
            req.queryParameters.select = this.config.getUserAttributesToGet();
        });
    }

    public List<User> getUsersFilteredBy(AzureFilter filters) {
        String filter = AzureUtils.getFilter(filters);
        LOG.ok("Searching users with filter {0}", new Object[]{filter});
        UserCollectionResponse result = this.getGraphServiceClient().users().get(req -> {
            req.queryParameters.filter = filter;
            req.queryParameters.select = this.config.getUserAttributesToGet();
            req.queryParameters.orderby = new String[]{"displayName"};
            req.headers.add("ConsistencyLevel", "eventual");
        });
        return Optional.ofNullable(result).map(UserCollectionResponse::getValue).orElse(Collections.emptyList());
    }

    public List<User> getAllMembersOfGroup(String groupId) {
        LOG.ok("Get all members of group {0}", new Object[]{groupId});
        DirectoryObjectCollectionResponse result = this.getGraphServiceClient().groups().byGroupId(groupId).members().get();
        ArrayList<User> users = new ArrayList<User>();
        if (result != null) {
            result.getValue().stream().filter(User.class::isInstance).map(User.class::cast).forEach(users::add);
        }
        return users;
    }

    public void addUserToGroup(String userId, String groupId) {
        LOG.ok("Adding user {0} to group {1}", new Object[]{userId, groupId});
        try {
            ReferenceCreate referenceCreate = new ReferenceCreate();
            referenceCreate.setOdataId("https://graph.microsoft.com/v1.0/directoryObjects/" + userId);
            this.getGraphServiceClient().groups().byGroupId(groupId).members().ref().post(referenceCreate);
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While adding User to Group", ex);
        }
    }

    public void deleteUserFromGroup(String userId, String groupId) {
        LOG.ok("Deleting user {0} from group {1}", new Object[]{userId, groupId});
        try {
            this.getGraphServiceClient().groups().byGroupId(groupId).members().byDirectoryObjectId(userId).ref().delete();
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While deleting User from Group", ex);
        }
    }

    public List<Group> getAllGroups() {
        LOG.ok("Get all groups", new Object[0]);
        GroupCollectionResponse result = this.getGraphServiceClient().groups().get(req -> {
            req.queryParameters.select = this.config.getGroupAttributesToGet();
            req.queryParameters.orderby = new String[]{"displayName"};
        });
        return Optional.ofNullable(result).map(GroupCollectionResponse::getValue).orElse(Collections.emptyList());
    }

    public GroupCollectionResponse getAllGroups(int pageSize) {
        LOG.ok("Get all groups with page size {0}", new Object[]{pageSize});
        return this.getGraphServiceClient().groups().get(req -> {
            req.queryParameters.select = this.config.getGroupAttributesToGet();
            req.queryParameters.orderby = new String[]{"displayName"};
            req.queryParameters.top = pageSize;
        });
    }

    public GroupCollectionResponse getAllGroupsNextPage(String odataNextLink) {
        LOG.ok("Get all groups next page {0}", new Object[]{odataNextLink});
        return this.getGraphServiceClient().groups().withUrl(odataNextLink).get();
    }

    public DirectoryObjectCollectionResponse getAllGroupsForUser(String userId) {
        LOG.ok("Get all groups user {0} is member", new Object[]{userId});
        return this.getGraphServiceClient().users().byUserId(userId).memberOf().get();
    }

    public DirectoryObjectCollectionResponse getAllGroupsForUser(String userId, String odataNextLink) {
        LOG.ok("Get all groups user {0} is member next page {1}", new Object[]{userId, odataNextLink});
        return this.getGraphServiceClient().users().byUserId("userId").memberOf().withUrl(odataNextLink).get();
    }

    public List<Group> getAllGroupsForGroup(String groupId) {
        LOG.ok("Get all groups group {0} is member", new Object[]{groupId});
        DirectoryObjectCollectionResponse result = this.getGraphServiceClient().groups().byGroupId(groupId).memberOf().get();
        ArrayList<Group> groups = new ArrayList<Group>();
        if (result != null) {
            result.getValue().stream().filter(Group.class::isInstance).map(Group.class::cast).forEach(groups::add);
        }
        return groups;
    }

    public Group getGroup(String groupId) {
        LOG.ok("Getting group {0}", new Object[]{groupId});
        return this.getGraphServiceClient().groups().byGroupId(groupId).get(req -> {
            req.queryParameters.select = this.config.getGroupAttributesToGet();
        });
    }

    public List<Group> getGroupsFilteredBy(AzureFilter filters) {
        String filter = AzureUtils.getFilter(filters);
        LOG.ok("Searching groups with filter {0}", new Object[]{filter});
        GroupCollectionResponse result = this.getGraphServiceClient().groups().get(req -> {
            req.queryParameters.filter = filter;
            req.queryParameters.select = this.config.getGroupAttributesToGet();
            req.queryParameters.orderby = new String[]{"displayName"};
            req.headers.add("ConsistencyLevel", "eventual");
        });
        return Optional.ofNullable(result).map(GroupCollectionResponse::getValue).orElse(Collections.emptyList());
    }

    public DirectoryObject getDeletedDirectoryObject(String id) {
        LOG.ok("Get deleted directory object {0} if exists", new Object[]{id});
        return this.getGraphServiceClient().directory().deletedItems().byDirectoryObjectId(id).get();
    }

    public User createUser(User user) {
        return this.getGraphServiceClient().users().post(user);
    }

    public Group createGroup(Group group) {
        return this.getGraphServiceClient().groups().post(group);
    }

    public User updateUser(User user) {
        return this.getGraphServiceClient().users().byUserId(user.getId()).patch(user);
    }

    public Group updateGroup(Group group) {
        return this.getGraphServiceClient().groups().byGroupId(group.getId()).patch(group);
    }

    public void deleteUser(String userId) {
        this.getGraphServiceClient().users().byUserId(userId).delete();
    }

    public void deleteGroup(String groupId) {
        this.getGraphServiceClient().groups().byGroupId(groupId).delete();
    }

    public DirectoryObject restoreDirectoryObject(String id) {
        return this.getGraphServiceClient().directory().deletedItems().byDirectoryObjectId(id).restore().post();
    }

    public List<SubscribedSku> getCurrentTenantSubscriptions() {
        LOG.ok("Get all subscriptions", new Object[0]);
        SubscribedSkuCollectionResponse result = this.getGraphServiceClient().subscribedSkus().get();
        return Optional.ofNullable(result).map(SubscribedSkuCollectionResponse::getValue).orElse(Collections.emptyList());
    }

    public List<String> getCurrentTenantSkuIds(boolean onlyEnabled) {
        LOG.ok("Get all enabled subscriptions", new Object[0]);
        SubscribedSkuCollectionResponse result = this.getGraphServiceClient().subscribedSkus().get();
        if (result == null) {
            return Collections.emptyList();
        }
        return result.getValue().stream().filter(sku -> !onlyEnabled || sku.getCapabilityStatus().equalsIgnoreCase("enabled")).map(Object::toString).collect(Collectors.toList());
    }

    public void assignLicense(String userId, AssignLicensePostRequestBody assignedLicense) {
        LOG.ok("Assigning licenses to user {0}", new Object[]{userId});
        this.getGraphServiceClient().users().byUserId(userId).assignLicense().post(assignedLicense);
    }

    public boolean isMemberOf(String memberId, String groupId) {
        DirectoryObjectCollectionResponse result = this.getGraphServiceClient().groups().byGroupId(groupId).members().get(req -> {
            req.queryParameters.filter = "id eq '" + memberId + "'";
        });
        return Optional.ofNullable(result).map(r -> !r.getValue().isEmpty()).orElse(false);
    }

    public List<String> getMemberGroups(String resourceId, boolean securityEnabledOnly) {
        GetMemberGroupsPostRequestBody securityEnabled = new GetMemberGroupsPostRequestBody();
        securityEnabled.setSecurityEnabledOnly(Boolean.valueOf(securityEnabledOnly));
        return this.getGraphServiceClient().directoryObjects().byDirectoryObjectId(resourceId).getMemberGroups().post(securityEnabled).getValue();
    }

    public List<String> getMemberObjects(String resourceId, boolean securityEnabledOnly) {
        GetMemberObjectsPostRequestBody securityEnabled = new GetMemberObjectsPostRequestBody();
        securityEnabled.setSecurityEnabledOnly(Boolean.valueOf(securityEnabledOnly));
        return this.getGraphServiceClient().directoryObjects().byDirectoryObjectId(resourceId).getMemberObjects().post(securityEnabled).getValue();
    }
}

