/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.LocaleUtils;
import com.googlecode.wicket.kendo.ui.form.datetime.DatePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.TimePicker;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.DateConverter;

public class DateTimePicker
extends FormComponentPanel<Date>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    protected DatePicker datePicker;
    protected TimePicker timePicker;
    private final Locale locale;
    private final String datePattern;
    private final String timePattern;
    private boolean timePickerEnabled = true;

    public DateTimePicker(String id) {
        this(id, null, null, "MM/dd/yyyy", "h:mm aa");
    }

    public DateTimePicker(String id, Locale locale) {
        this(id, null, locale, LocaleUtils.getLocaleDatePattern((Locale)locale, (String)"MM/dd/yyyy"), LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm aa"));
    }

    public DateTimePicker(String id, String datePattern, String timePattern) {
        this(id, null, null, datePattern, timePattern);
    }

    public DateTimePicker(String id, Locale locale, String datePattern, String timePattern) {
        this(id, null, locale, datePattern, timePattern);
    }

    public DateTimePicker(String id, IModel<Date> model) {
        this(id, model, null, "MM/dd/yyyy", "h:mm aa");
    }

    public DateTimePicker(String id, IModel<Date> model, Locale locale) {
        this(id, model, locale, LocaleUtils.getLocaleDatePattern((Locale)locale, (String)"MM/dd/yyyy"), LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm aa"));
    }

    public DateTimePicker(String id, IModel<Date> model, String datePattern, String timePattern) {
        this(id, model, null, datePattern, timePattern);
    }

    public DateTimePicker(String id, IModel<Date> model, Locale locale, String datePattern, String timePattern) {
        super(id, model);
        this.locale = locale;
        this.datePattern = datePattern;
        this.timePattern = timePattern;
        this.setType(Date.class);
    }

    public String getInput() {
        String dateInput = this.datePicker.getInput();
        String timeInput = this.timePicker.getInput();
        return this.formatInput(dateInput, timeInput);
    }

    protected String formatInput(String dateInput, String timeInput) {
        if (this.isTimePickerEnabled()) {
            return String.format("%s %s", dateInput, timeInput);
        }
        return dateInput;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (Date.class.isAssignableFrom(type)) {
            return DateTimePicker.newConverter(this.getTextFormat());
        }
        return super.getConverter(type);
    }

    public final String getTextFormat() {
        if (this.isTimePickerEnabled()) {
            return String.format("%s %s", this.getDatePattern(), this.getTimePattern());
        }
        return this.getDatePattern();
    }

    public String getModelObjectAsString() {
        Date date = (Date)this.getModelObject();
        if (date != null) {
            return new SimpleDateFormat(this.getTextFormat(), this.getLocale()).format(date);
        }
        return "";
    }

    public final String getDatePattern() {
        return this.datePattern;
    }

    public final String getTimePattern() {
        return this.timePattern;
    }

    public final boolean isTimePickerEnabled() {
        return this.timePickerEnabled;
    }

    public final DateTimePicker setTimePickerEnabled(boolean enabled) {
        this.timePickerEnabled = enabled;
        return this;
    }

    public final void setTimePickerEnabled(IPartialPageRequestHandler handler, boolean enabled) {
        this.timePickerEnabled = enabled;
        handler.add(new Component[]{this.timePicker});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.datePicker = this.newDatePicker("datepicker", (IModel<Date>)this.getModel(), this.getLocale(), this.getDatePattern(), new Options());
        this.timePicker = this.newTimePicker("timepicker", (IModel<Date>)this.getModel(), this.getLocale(), this.getTimePattern(), new Options());
        this.add(new Component[]{this.datePicker});
        this.add(new Component[]{this.timePicker});
    }

    private static IConverter<Date> newConverter(final String pattern) {
        return new DateConverter(){
            private static final long serialVersionUID = 1L;

            public DateFormat getDateFormat(Locale locale) {
                return new SimpleDateFormat(pattern, locale != null ? locale : Locale.getDefault());
            }
        };
    }

    protected DatePicker newDatePicker(String id, IModel<Date> model, Locale locale, String datePattern, Options options) {
        return new DatePicker(id, model, locale, datePattern, options){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(DateTimePicker.this.isEnabled());
            }

            public void convertInput() {
            }
        };
    }

    protected TimePicker newTimePicker(String id, IModel<Date> model, Locale locale, String timePattern, Options options) {
        return new TimePicker(id, model, locale, timePattern, options){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(DateTimePicker.this.isEnabled() && DateTimePicker.this.isTimePickerEnabled());
            }

            public void convertInput() {
            }
        };
    }
}

