/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.key;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springmodules.cache.key.CacheKeyGenerator;
import org.springmodules.cache.key.HashCodeCacheKey;
import org.springmodules.cache.key.HashCodeCalculator;
import org.springmodules.cache.util.Reflections;
import org.springmodules.util.Objects;

public class HashCodeCacheKeyGenerator
implements CacheKeyGenerator {
    private boolean generateArgumentHashCode;

    public HashCodeCacheKeyGenerator() {
    }

    public HashCodeCacheKeyGenerator(boolean generateArgumentHashCode) {
        this();
        this.setGenerateArgumentHashCode(generateArgumentHashCode);
    }

    public final Serializable generateKey(MethodInvocation methodInvocation) {
        HashCodeCalculator hashCodeCalculator = new HashCodeCalculator();
        Method method = methodInvocation.getMethod();
        hashCodeCalculator.append(System.identityHashCode(method));
        Object[] methodArguments = methodInvocation.getArguments();
        if (methodArguments != null) {
            int methodArgumentCount = methodArguments.length;
            for (int i = 0; i < methodArgumentCount; ++i) {
                Object methodArgument = methodArguments[i];
                int hash = 0;
                hash = this.generateArgumentHashCode ? Reflections.reflectionHashCode(methodArgument) : Objects.nullSafeHashCode(methodArgument);
                hashCodeCalculator.append(hash);
            }
        }
        long checkSum = hashCodeCalculator.getCheckSum();
        int hashCode = hashCodeCalculator.getHashCode();
        HashCodeCacheKey cacheKey = new HashCodeCacheKey(checkSum, hashCode);
        return cacheKey;
    }

    public final void setGenerateArgumentHashCode(boolean newGenerateArgumentHashCode) {
        this.generateArgumentHashCode = newGenerateArgumentHashCode;
    }
}

