/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.consent.ConsentDecision;
import org.apereo.cas.consent.ConsentRepository;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.RandomUtils;

public abstract class BaseConsentRepository
implements ConsentRepository {
    private static final long serialVersionUID = 1736846688546785564L;
    private Set<ConsentDecision> consentDecisions = Collections.synchronizedSet(new LinkedHashSet(0));

    public ConsentDecision findConsentDecision(Service service, RegisteredService registeredService, Authentication authentication) {
        return this.consentDecisions.stream().filter(d -> d.getPrincipal().equals(authentication.getPrincipal().getId()) && d.getService().equals(service.getId())).findFirst().orElse(null);
    }

    public Collection<? extends ConsentDecision> findConsentDecisions(String principal) {
        return this.consentDecisions.stream().filter(d -> d.getPrincipal().equals(principal)).collect(Collectors.toSet());
    }

    public Collection<? extends ConsentDecision> findConsentDecisions() {
        return new ArrayList<ConsentDecision>(this.consentDecisions);
    }

    public ConsentDecision storeConsentDecision(ConsentDecision decision) {
        boolean consent = this.getConsentDecisions().stream().anyMatch(d -> d.getId() == decision.getId());
        if (consent) {
            this.getConsentDecisions().remove(decision);
        } else {
            decision.setId(RandomUtils.nextLong());
        }
        this.getConsentDecisions().add(decision);
        return decision;
    }

    public boolean deleteConsentDecision(long decisionId, String principal) {
        return this.consentDecisions.removeIf(d -> d.getId() == decisionId && d.getPrincipal().equalsIgnoreCase(principal));
    }

    public void deleteAll() {
        this.consentDecisions.clear();
    }

    public boolean deleteConsentDecisions(String principal) {
        return this.consentDecisions.removeIf(consentDecision -> consentDecision.getPrincipal().equalsIgnoreCase(principal));
    }

    @Generated
    public void setConsentDecisions(Set<ConsentDecision> consentDecisions) {
        this.consentDecisions = consentDecisions;
    }

    @Generated
    protected BaseConsentRepository() {
    }

    @Generated
    protected BaseConsentRepository(Set<ConsentDecision> consentDecisions) {
        this.consentDecisions = consentDecisions;
    }

    @Generated
    public Set<ConsentDecision> getConsentDecisions() {
        return this.consentDecisions;
    }
}

