/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.servlet;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.mvc.servlet.AbstractFlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandler;

public class FlowHandlerMapping
extends AbstractHandlerMapping {
    private static final Log logger = LogFactory.getLog(FlowHandlerMapping.class);
    private FlowDefinitionRegistry flowRegistry;
    private FlowUrlHandler flowUrlHandler;

    public FlowDefinitionRegistry getFlowRegistry() {
        return this.flowRegistry;
    }

    public void setFlowRegistry(FlowDefinitionRegistry flowRegistry) {
        this.flowRegistry = flowRegistry;
    }

    public FlowUrlHandler getFlowUrlHandler() {
        return this.flowUrlHandler;
    }

    public void setFlowUrlHandler(FlowUrlHandler flowUrlHandler) {
        this.flowUrlHandler = flowUrlHandler;
    }

    protected void initServletContext(ServletContext servletContext) {
        Assert.notNull((Object)this.flowRegistry, (String)"The FlowRegistry to query when mapping requests is required");
        if (this.flowUrlHandler == null) {
            this.flowUrlHandler = new DefaultFlowUrlHandler();
        }
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        Object handler;
        String flowId = this.flowUrlHandler.getFlowId(request);
        if (flowId == null) {
            return null;
        }
        if (this.getApplicationContext().containsBean(flowId) && (handler = this.getApplicationContext().getBean(flowId)) instanceof FlowHandler) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Mapping request with URI '" + request.getRequestURI() + "' to flow with id '" + flowId + "'; custom FlowHandler " + handler + " will manage flow execution"));
            }
            return handler;
        }
        if (this.flowRegistry.containsFlowDefinition(flowId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Mapping request with URI '" + request.getRequestURI() + "' to flow with id '" + flowId + "'"));
            }
            return this.createDefaultFlowHandler(flowId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No flow mapping found for request with URI '" + request.getRequestURI() + "'"));
        }
        return null;
    }

    protected FlowHandler createDefaultFlowHandler(String flowId) {
        return new DefaultFlowHandler(flowId);
    }

    private static class DefaultFlowHandler
    extends AbstractFlowHandler {
        private String flowId;

        public DefaultFlowHandler(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public String getFlowId() {
            return this.flowId;
        }
    }
}

