/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.policy;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.policy.PolicyRule;
import com.okta.sdk.resource.policy.PolicyRuleActions;
import com.okta.sdk.resource.policy.PolicyRuleConditions;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPolicyRule
extends AbstractInstanceResource<PolicyRule>
implements PolicyRule {
    private static final ResourceReference<PolicyRuleActions> actionsProperty = new ResourceReference<PolicyRuleActions>("actions", PolicyRuleActions.class, false);
    private static final ResourceReference<PolicyRuleConditions> conditionsProperty = new ResourceReference<PolicyRuleConditions>("conditions", PolicyRuleConditions.class, false);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final IntegerProperty priorityProperty = new IntegerProperty("priority");
    private static final EnumProperty<PolicyRule.StatusEnum> statusProperty = new EnumProperty<PolicyRule.StatusEnum>("status", PolicyRule.StatusEnum.class);
    private static final BooleanProperty systemProperty = new BooleanProperty("system");
    private static final EnumProperty<PolicyRule.TypeEnum> typeProperty = new EnumProperty<PolicyRule.TypeEnum>("type", PolicyRule.TypeEnum.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultPolicyRule.createPropertyDescriptorMap(actionsProperty, conditionsProperty, createdProperty, idProperty, lastUpdatedProperty, nameProperty, priorityProperty, statusProperty, systemProperty, typeProperty);

    public DefaultPolicyRule(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultPolicyRule(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return PolicyRule.class;
    }

    public PolicyRuleActions getActions() {
        return this.getResourceProperty(actionsProperty);
    }

    public PolicyRule setActions(PolicyRuleActions actions) {
        this.setProperty(actionsProperty, (Object)actions);
        return this;
    }

    public PolicyRuleConditions getConditions() {
        return this.getResourceProperty(conditionsProperty);
    }

    public PolicyRule setConditions(PolicyRuleConditions conditions) {
        this.setProperty(conditionsProperty, (Object)conditions);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public PolicyRule setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public Integer getPriority() {
        return this.getIntProperty(priorityProperty);
    }

    public PolicyRule setPriority(Integer priority) {
        this.setProperty(priorityProperty, (Object)priority);
        return this;
    }

    public PolicyRule.StatusEnum getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public PolicyRule setStatus(PolicyRule.StatusEnum status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public Boolean getSystem() {
        return this.getBoolean(systemProperty);
    }

    public PolicyRule setSystem(Boolean system) {
        this.setProperty(systemProperty, (Object)system);
        return this;
    }

    public PolicyRule.TypeEnum getType() {
        return this.getEnumProperty(typeProperty);
    }

    public PolicyRule setType(PolicyRule.TypeEnum type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public PolicyRule update() {
        String ruleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/policies/{policyId}/rules/{ruleId}");
        String policyId = pathArgs.get("policyId");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/policies/" + policyId + "/rules/" + ruleId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public void activate() {
        String ruleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/policies/{policyId}/rules/{ruleId}/lifecycle/activate");
        String policyId = pathArgs.get("policyId");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivate() {
        String ruleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate");
        String policyId = pathArgs.get("policyId");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    @Override
    public void delete() {
        String ruleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/policies/{policyId}/rules/{ruleId}");
        String policyId = pathArgs.get("policyId");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/policies/" + policyId + "/rules/" + ruleId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }
}

