/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.AuthenticationResultBuilderFactory;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.AuthenticationTransactionFactory;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.authentication.DefaultAuthenticationAttributeReleasePolicy;
import org.apereo.cas.authentication.DefaultAuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.DefaultAuthenticationManager;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilderFactory;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionFactory;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionManager;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.handler.DefaultAuthenticationHandlerResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.AuthenticationAttributeReleaseProperties;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication})
@Configuration(value="CasCoreAuthenticationConfiguration", proxyBeanMethods=false)
class CasCoreAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuthenticationConfiguration.class);

    CasCoreAuthenticationConfiguration() {
    }

    @Configuration(value="CasCoreAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @AutoConfigureOrder(value=-2147483648)
    static class CasCoreAuthenticationPlanConfiguration {
        CasCoreAuthenticationPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"authenticationEventExecutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlan authenticationEventExecutionPlan(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="defaultAuthenticationHandlerResolver") AuthenticationHandlerResolver defaultAuthenticationHandlerResolver, List<AuthenticationEventExecutionPlanConfigurer> configurers) {
            DefaultAuthenticationEventExecutionPlan plan = new DefaultAuthenticationEventExecutionPlan(defaultAuthenticationHandlerResolver, tenantExtractor);
            ArrayList<AuthenticationEventExecutionPlanConfigurer> sortedConfigurers = new ArrayList<AuthenticationEventExecutionPlanConfigurer>(configurers);
            sortedConfigurers.removeIf(BeanSupplier::isProxy);
            AnnotationAwareOrderComparator.sortIfNecessary(sortedConfigurers);
            sortedConfigurers.stream().filter(BeanSupplier::isNotProxy).forEach(Unchecked.consumer(configurer -> {
                LOGGER.trace("Configuring authentication execution plan [{}]", (Object)configurer.getName());
                configurer.configureAuthenticationExecutionPlan((AuthenticationEventExecutionPlan)plan);
            }));
            return plan;
        }

        @ConditionalOnMissingBean(name={"defaultAuthenticationHandlerResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationHandlerResolver defaultAuthenticationHandlerResolver() {
            return new DefaultAuthenticationHandlerResolver();
        }
    }

    @Configuration(value="CasCoreAuthenticationManagerConfiguration", proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    static class CasCoreAuthenticationManagerConfiguration {
        CasCoreAuthenticationManagerConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"authenticationTransactionManager"})
        public AuthenticationTransactionManager authenticationTransactionManager(@Qualifier(value="casAuthenticationManager") AuthenticationManager casAuthenticationManager, ConfigurableApplicationContext applicationContext) {
            return new DefaultAuthenticationTransactionManager((ApplicationEventPublisher)applicationContext, casAuthenticationManager);
        }

        @ConditionalOnMissingBean(name={"casAuthenticationManager"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationManager casAuthenticationManager(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="defaultAuthenticationSystemSupport") ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan) {
            boolean isFatal = casProperties.getPersonDirectory().getPrincipalResolutionFailureFatal() == TriStateBoolean.TRUE;
            return new DefaultAuthenticationManager(authenticationEventExecutionPlan, authenticationSystemSupport, isFatal, applicationContext);
        }
    }

    @Configuration(value="CasCoreAuthenticationBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuthenticationBaseConfiguration {
        CasCoreAuthenticationBaseConfiguration() {
        }

        @ConditionalOnMissingBean(name={"authenticationResultBuilderFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationResultBuilderFactory authenticationResultBuilderFactory(@Qualifier(value="principalElectionStrategy") PrincipalElectionStrategy principalElectionStrategy) {
            return new DefaultAuthenticationResultBuilderFactory(principalElectionStrategy);
        }

        @ConditionalOnMissingBean(name={"authenticationTransactionFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationTransactionFactory authenticationTransactionFactory(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultAuthenticationTransactionFactory(servicesManager);
        }

        @ConditionalOnMissingBean(name={"authenticationAttributeReleasePolicy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy(CasConfigurationProperties casProperties) {
            AuthenticationAttributeReleaseProperties release = casProperties.getAuthn().getAuthenticationAttributeRelease();
            if (!release.isEnabled()) {
                LOGGER.debug("CAS is configured to not release protocol-level authentication attributes.");
                return AuthenticationAttributeReleasePolicy.none();
            }
            return new DefaultAuthenticationAttributeReleasePolicy((Collection)release.getOnlyRelease(), (Collection)release.getNeverRelease(), casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute());
        }
    }
}

