/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

public class GroovyWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyWebflowConfigurer.class);

    public GroovyWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
    }

    @Override
    public void doInitialize() {
        FunctionUtils.doAndHandle(__ -> {
            Resource resource = this.casProperties.getWebflow().getGroovy().getLocation();
            if (resource != null) {
                Object[] args = new Object[]{this, this.applicationContext, LOGGER};
                LOGGER.debug("Executing Groovy script [{}] to auto-configure the webflow context", (Object)resource);
                ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
                try (ExecutableCompiledScript script = scriptFactory.fromResource(resource);){
                    script.execute(args, Object.class, true);
                }
            }
        });
    }
}

