/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response.query;

import java.util.Map;
import java.util.Objects;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11ResponseBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.ScratchContext;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;

public class SamlProfileAttributeQueryResponseBuilder
extends SamlProfileSamlSoap11ResponseBuilder {
    private static final long serialVersionUID = -5582616946993706815L;

    public SamlProfileAttributeQueryResponseBuilder(SamlProfileSamlResponseBuilderConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    public Envelope build(SamlProfileBuilderContext context) throws Exception {
        context.getHttpResponse().setContentType("application/xml");
        Header header = (Header)SamlUtils.newSoapObject(Header.class);
        Body body = (Body)SamlUtils.newSoapObject(Body.class);
        AttributeQuery query = (AttributeQuery)context.getSamlRequest();
        ScratchContext scratch = (ScratchContext)context.getMessageContext().ensureSubcontext(ScratchContext.class);
        Map map = Objects.requireNonNull(scratch).getMap();
        map.put("encodeSamlResponse", Boolean.FALSE);
        SamlProfileBuilderContext buildContext = context.transferTo((RequestAbstractType)query, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Response saml2Response = this.buildSaml2Response(buildContext);
        body.getUnknownXMLObjects().add(saml2Response);
        Envelope envelope = (Envelope)SamlUtils.newSoapObject(Envelope.class);
        envelope.setHeader(header);
        envelope.setBody(body);
        this.openSamlConfigBean.logObject((XMLObject)envelope);
        map.remove("encodeSamlResponse");
        return this.encodeFinalResponse(context, envelope);
    }
}

