/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.services;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcScopeFreeAttributeReleasePolicy;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceChainingAttributeReleasePolicy;
import org.apereo.cas.services.ServiceRegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcServiceRegistryListener
implements ServiceRegistryListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcServiceRegistryListener.class);
    private static final long serialVersionUID = -2492163812728091841L;
    private final OidcAttributeReleasePolicyFactory attributeReleasePolicyFactory;

    private static void addAttributeReleasePolicy(RegisteredServiceChainingAttributeReleasePolicy chain, BaseOidcScopeAttributeReleasePolicy policyToAdd, String givenScope, OidcRegisteredService registeredService) {
        LOGGER.debug("Mapped [{}] to attribute release policy [{}]", (Object)givenScope, (Object)policyToAdd.getClass().getSimpleName());
        RegisteredServiceAttributeReleasePolicy policy = registeredService.getAttributeReleasePolicy();
        ArrayList<OidcRegisteredServiceAttributeReleasePolicy> matchingPolicies = new ArrayList<OidcRegisteredServiceAttributeReleasePolicy>();
        if (policy instanceof RegisteredServiceChainingAttributeReleasePolicy) {
            RegisteredServiceChainingAttributeReleasePolicy chainedPolicy = (RegisteredServiceChainingAttributeReleasePolicy)policy;
            List<OidcRegisteredServiceAttributeReleasePolicy> policiesToAdd = OidcServiceRegistryListener.buildMatchingPolicies(givenScope, chainedPolicy.getPolicies());
            matchingPolicies.addAll(policiesToAdd);
        } else if (policy instanceof OidcRegisteredServiceAttributeReleasePolicy) {
            OidcRegisteredServiceAttributeReleasePolicy oidcPolicy = (OidcRegisteredServiceAttributeReleasePolicy)policy;
            List<OidcRegisteredServiceAttributeReleasePolicy> policiesToAdd = OidcServiceRegistryListener.buildMatchingPolicies(givenScope, List.of(oidcPolicy));
            matchingPolicies.addAll(policiesToAdd);
        }
        if (matchingPolicies.isEmpty()) {
            policyToAdd.setConsentPolicy(policy.getConsentPolicy());
            policyToAdd.setPrincipalAttributesRepository(policy.getPrincipalAttributesRepository());
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{policyToAdd});
        } else {
            chain.addPolicies(matchingPolicies);
        }
    }

    private static List<OidcRegisteredServiceAttributeReleasePolicy> buildMatchingPolicies(String givenScope, List<RegisteredServiceAttributeReleasePolicy> policies) {
        return policies.stream().filter(OidcRegisteredServiceAttributeReleasePolicy.class::isInstance).map(OidcRegisteredServiceAttributeReleasePolicy.class::cast).filter(policy -> {
            OidcCustomScopeAttributeReleasePolicy customPolicy;
            return policy.getScopeType().equalsIgnoreCase(givenScope) || policy instanceof OidcCustomScopeAttributeReleasePolicy && (customPolicy = (OidcCustomScopeAttributeReleasePolicy)policy).getScopeName().equals(givenScope);
        }).toList();
    }

    public RegisteredService postLoad(RegisteredService registeredService) {
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService oidcService = (OidcRegisteredService)registeredService;
            return this.reconcile(oidcService);
        }
        return registeredService;
    }

    /*
     * Unable to fully structure code
     */
    protected RegisteredService reconcile(OidcRegisteredService oidcService) {
        OidcServiceRegistryListener.LOGGER.trace("Reconciling OpenID Connect scopes and claims for [{}]", (Object)oidcService.getServiceId());
        definedServiceScopes = oidcService.getScopes();
        if (definedServiceScopes.isEmpty()) {
            OidcServiceRegistryListener.LOGGER.trace("Registered service [{}] does not define any scopes to control attribute release policies. CAS will allow the existing attribute release policies assigned to the service to operate without a scope.", (Object)oidcService.getServiceId());
            return oidcService;
        }
        userScopes = this.attributeReleasePolicyFactory.getUserDefinedScopes();
        customClaims = new ArrayList<String>();
        policyChain = new ChainingAttributeReleasePolicy();
        definedServiceScopes.forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$reconcile$5(org.apereo.cas.services.OidcRegisteredService java.util.Collection org.apereo.cas.services.ChainingAttributeReleasePolicy java.util.ArrayList java.lang.String ), (Ljava/lang/String;)V)((OidcServiceRegistryListener)this, (OidcRegisteredService)oidcService, userScopes, (ChainingAttributeReleasePolicy)policyChain, customClaims));
        if (!customClaims.isEmpty()) {
            userPolicy = this.attributeReleasePolicyFactory.custom("custom", customClaims);
            OidcServiceRegistryListener.addAttributeReleasePolicy((RegisteredServiceChainingAttributeReleasePolicy)policyChain, (BaseOidcScopeAttributeReleasePolicy)userPolicy, userPolicy.getScopeName(), oidcService);
        }
        if (definedServiceScopes.isEmpty() || definedServiceScopes.size() == 1 && definedServiceScopes.contains(OidcConstants.StandardScopes.OPENID.getScope()) || oidcService.getAttributeReleasePolicy() instanceof OidcScopeFreeAttributeReleasePolicy) ** GOTO lbl-1000
        var8_8 = oidcService.getAttributeReleasePolicy();
        if (var8_8 instanceof RegisteredServiceChainingAttributeReleasePolicy) {
            chain = (RegisteredServiceChainingAttributeReleasePolicy)var8_8;
            ** if (!chain.getPolicies().stream().anyMatch((Predicate<RegisteredServiceAttributeReleasePolicy>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/apereo/cas/services/RegisteredServiceAttributeReleasePolicy;)Z)(OidcScopeFreeAttributeReleasePolicy.class))) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl25
        }
lbl-1000:
        // 2 sources

        {
            v0 = scopeFree = false;
        }
lbl25:
        // 2 sources

        if (scopeFree) {
            OidcServiceRegistryListener.LOGGER.trace("Service definition [{}] will use the assigned attribute release policy without scopes", (Object)oidcService.getName());
            var8_8 = oidcService.getAttributeReleasePolicy();
            if (var8_8 instanceof RegisteredServiceChainingAttributeReleasePolicy) {
                chain = (RegisteredServiceChainingAttributeReleasePolicy)var8_8;
                policyChain.addPolicies(chain.getPolicies().toArray(new RegisteredServiceAttributeReleasePolicy[0]));
            } else {
                policyChain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{oidcService.getAttributeReleasePolicy()});
            }
        }
        if (policyChain.getPolicies().isEmpty()) {
            OidcServiceRegistryListener.LOGGER.debug("No attribute release policy could be determined based on given scopes. No claims/attributes will be released to [{}]", (Object)oidcService.getServiceId());
            oidcService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new DenyAllAttributeReleasePolicy());
        } else if (policyChain.size() == 1) {
            oidcService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policyChain.getPolicies().getFirst());
        } else {
            oidcService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policyChain);
        }
        OidcServiceRegistryListener.LOGGER.trace("Scope/claim reconciliation for service [{}] resulted in the following attribute release policy [{}]", (Object)oidcService.getServiceId(), (Object)oidcService.getAttributeReleasePolicy());
        return oidcService;
    }

    @Generated
    public OidcServiceRegistryListener(OidcAttributeReleasePolicyFactory attributeReleasePolicyFactory) {
        this.attributeReleasePolicyFactory = attributeReleasePolicyFactory;
    }

    private /* synthetic */ void lambda$reconcile$5(OidcRegisteredService oidcService, Collection userScopes, ChainingAttributeReleasePolicy policyChain, ArrayList customClaims, String givenScope) {
        LOGGER.trace("Reviewing scope [{}] for [{}]", (Object)givenScope, (Object)oidcService.getServiceId());
        boolean userDefinedScope = Arrays.stream(OidcConstants.StandardScopes.values()).noneMatch(scope -> scope.getScope().trim().equalsIgnoreCase(givenScope.trim()));
        if (userDefinedScope) {
            LOGGER.debug("[{}] appears to be a user-defined scope and does not match any of the predefined standard scopes. Checking [{}] against user-defined scopes provided as [{}]", new Object[]{givenScope, givenScope, userScopes});
            userScopes.stream().filter(scope -> scope.getScopeName().equals(givenScope.trim())).findFirst().ifPresentOrElse(userPolicy -> OidcServiceRegistryListener.addAttributeReleasePolicy((RegisteredServiceChainingAttributeReleasePolicy)policyChain, (BaseOidcScopeAttributeReleasePolicy)userPolicy, givenScope, oidcService), () -> customClaims.add(givenScope.trim()));
        } else {
            OidcConstants.StandardScopes scope2 = OidcConstants.StandardScopes.valueOf((String)givenScope.trim().toUpperCase(Locale.ENGLISH));
            switch (scope2) {
                case EMAIL: 
                case ADDRESS: 
                case PROFILE: 
                case PHONE: 
                case ASSURANCE: {
                    BaseOidcScopeAttributeReleasePolicy policyToAdd = this.attributeReleasePolicyFactory.get(scope2);
                    OidcServiceRegistryListener.addAttributeReleasePolicy((RegisteredServiceChainingAttributeReleasePolicy)policyChain, policyToAdd, givenScope, oidcService);
                    break;
                }
                case OPENID: {
                    LOGGER.debug("Scope [{}] is found for service [{}]", (Object)givenScope, (Object)oidcService.getId());
                    break;
                }
                case OFFLINE_ACCESS: {
                    LOGGER.debug("Given scope [{}], service [{}] is marked to generate refresh tokens", (Object)givenScope, (Object)oidcService.getId());
                    oidcService.setGenerateRefreshToken(true);
                }
            }
        }
    }
}

