/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.ValueAndTimestampDeserializer;

public class ChangeLoggingTimestampedKeyValueBytesStore
extends ChangeLoggingKeyValueBytesStore {
    ChangeLoggingTimestampedKeyValueBytesStore(KeyValueStore<Bytes, byte[]> inner) {
        super(inner);
    }

    @Override
    public void put(Bytes key, byte[] valueAndTimestamp) {
        ((KeyValueStore)this.wrapped()).put(key, valueAndTimestamp);
        this.log(key, ValueAndTimestampDeserializer.rawValue(valueAndTimestamp), valueAndTimestamp == null ? this.context.timestamp() : ValueAndTimestampDeserializer.timestamp(valueAndTimestamp));
    }

    @Override
    public byte[] putIfAbsent(Bytes key, byte[] valueAndTimestamp) {
        byte[] previous = ((KeyValueStore)this.wrapped()).putIfAbsent(key, valueAndTimestamp);
        if (previous == null) {
            this.log(key, ValueAndTimestampDeserializer.rawValue(valueAndTimestamp), valueAndTimestamp == null ? this.context.timestamp() : ValueAndTimestampDeserializer.timestamp(valueAndTimestamp));
        }
        return previous;
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        ((KeyValueStore)this.wrapped()).putAll(entries);
        for (KeyValue entry : entries) {
            byte[] valueAndTimestamp = (byte[])entry.value;
            this.log((Bytes)entry.key, ValueAndTimestampDeserializer.rawValue(valueAndTimestamp), valueAndTimestamp == null ? this.context.timestamp() : ValueAndTimestampDeserializer.timestamp(valueAndTimestamp));
        }
    }
}

