/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.PrepareFunc;

public class StoreSerdeInitializer {
    static <K, V> StateSerdes<K, V> prepareStoreSerde(StateStoreContext context, String storeName, String changelogTopic, Serde<K> keySerde, Serde<V> valueSerde, PrepareFunc<V> prepareValueSerdeFunc) {
        return new StateSerdes(changelogTopic, StoreSerdeInitializer.prepareSerde(WrappingNullableUtils::prepareKeySerde, storeName, keySerde, new SerdeGetter(context), true, context.taskId()), StoreSerdeInitializer.prepareSerde(prepareValueSerdeFunc, storeName, valueSerde, new SerdeGetter(context), false, context.taskId()));
    }

    static <K, V> StateSerdes<K, V> prepareStoreSerde(ProcessorContext context, String storeName, String changelogTopic, Serde<K> keySerde, Serde<V> valueSerde, PrepareFunc<V> prepareValueSerdeFunc) {
        return new StateSerdes(changelogTopic, StoreSerdeInitializer.prepareSerde(WrappingNullableUtils::prepareKeySerde, storeName, keySerde, new SerdeGetter(context), true, context.taskId()), StoreSerdeInitializer.prepareSerde(prepareValueSerdeFunc, storeName, valueSerde, new SerdeGetter(context), false, context.taskId()));
    }

    private static <T> Serde<T> prepareSerde(PrepareFunc<T> prepare, String storeName, Serde<T> serde, SerdeGetter getter, Boolean isKey, TaskId taskId) {
        String serdeType = isKey != false ? "key" : "value";
        try {
            return prepare.prepareSerde(serde, getter);
        }
        catch (ConfigException | StreamsException e) {
            throw new StreamsException(String.format("Failed to initialize %s serdes for store %s", serdeType, storeName), (Throwable)e, taskId);
        }
    }
}

