/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.RelationshipUR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Relatable;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AccountGetter;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PlainAttrGetter;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.core.provisioning.java.data.AttributableDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Uid;

abstract class AnyDataBinder
extends AttributableDataBinder {
    protected final AnyTypeDAO anyTypeDAO;
    protected final RealmSearchDAO realmSearchDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final RelationshipTypeDAO relationshipTypeDAO;
    protected final EntityFactory entityFactory;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final OutboundMatcher outboundMatcher;

    protected static void fillTO(AnyTO anyTO, String realmFullPath, Collection<? extends AnyTypeClass> auxClasses, Collection<PlainAttr> plainAttrs, Map<DerSchema, String> derAttrs, Collection<? extends ExternalResource> resources) {
        anyTO.setRealm(realmFullPath);
        anyTO.getAuxClasses().addAll(auxClasses.stream().map(Entity::getKey).toList());
        plainAttrs.forEach(plainAttr -> anyTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        derAttrs.forEach((schema, value) -> anyTO.getDerAttrs().add(new Attr.Builder(schema.getKey()).value(value).build()));
        anyTO.getResources().addAll(resources.stream().map(Entity::getKey).collect(Collectors.toSet()));
    }

    protected static RelationshipTO getRelationshipTO(String relationshipType, RelationshipTO.End end, Any otherEnd) {
        String string;
        RelationshipTO.Builder builder = new RelationshipTO.Builder(relationshipType, end);
        String string2 = otherEnd.getType().getKey();
        String string3 = otherEnd.getKey();
        if (otherEnd instanceof User) {
            User user = (User)otherEnd;
            string = user.getUsername();
        } else if (otherEnd instanceof Group) {
            Group group = (Group)otherEnd;
            string = group.getName();
        } else {
            string = ((AnyObject)otherEnd).getName();
        }
        return builder.otherEnd(string2, string3, string).build();
    }

    protected static MembershipTO getMembershipTO(Collection<PlainAttr> plainAttrs, Map<DerSchema, String> derAttrs, Membership<? extends Any> membership) {
        MembershipTO membershipTO = new MembershipTO.Builder(((Group)membership.getRightEnd()).getKey()).groupName(((Group)membership.getRightEnd()).getName()).build();
        plainAttrs.forEach(plainAttr -> membershipTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        derAttrs.forEach((schema, value) -> membershipTO.getDerAttrs().add(new Attr.Builder(schema.getKey()).value(value).build()));
        return membershipTO;
    }

    protected AnyDataBinder(AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, JexlTools jexlTools) {
        super(plainSchemaDAO, validator, derAttrHandler, mappingManager, intAttrNameParser, jexlTools);
        this.anyTypeDAO = anyTypeDAO;
        this.realmSearchDAO = realmSearchDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.resourceDAO = resourceDAO;
        this.relationshipTypeDAO = relationshipTypeDAO;
        this.entityFactory = entityFactory;
        this.anyUtilsFactory = anyUtilsFactory;
        this.outboundMatcher = outboundMatcher;
    }

    protected void setRealm(Any any, AnyUR anyUR) {
        if (anyUR.getRealm() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)anyUR.getRealm().getValue()))) {
            this.realmSearchDAO.findByFullPath((String)anyUR.getRealm().getValue()).ifPresentOrElse(arg_0 -> ((Any)any).setRealm(arg_0), () -> LOG.debug("Invalid realm specified: {}, ignoring", anyUR.getRealm().getValue()));
        }
    }

    protected Map<String, ConnObject> onResources(Any any, Collection<String> resources, String password, Set<String> changePwdRes) {
        HashMap<String, ConnObject> onResources = new HashMap<String, ConnObject>();
        resources.stream().map(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).findById(arg_0)).flatMap(Optional::stream).forEach(resource -> resource.getProvisionByAnyType(any.getType().getKey()).ifPresent(provision -> MappingUtils.getConnObjectKeyItem(provision).ifPresent(keyItem -> {
            ConnObject connObjectTO;
            MappingManager.PreparedAttrs prepared = this.mappingManager.prepareAttrsFromAny(any, password, changePwdRes.contains(resource.getKey()), Boolean.valueOf(true), resource, provision);
            if (StringUtils.isBlank((CharSequence)prepared.connObjectLink())) {
                connObjectTO = ConnObjectUtils.getConnObjectTO(null, prepared.attributes());
            } else {
                ConnectorObject connectorObject = new ConnectorObjectBuilder().addAttributes((Collection)prepared.attributes()).addAttribute(new Attribute[]{new Uid(prepared.connObjectLink())}).addAttribute(new Attribute[]{AttributeBuilder.build((String)keyItem.getExtAttrName(), (Object[])new Object[]{prepared.connObjectLink()})}).build();
                connObjectTO = ConnObjectUtils.getConnObjectTO(this.outboundMatcher.getFIQL(connectorObject, (ExternalResource)resource, (Provision)provision), connectorObject.getAttributes());
            }
            onResources.put(resource.getKey(), connObjectTO);
        })));
        return onResources;
    }

    protected List<String> evaluateMandatoryCondition(ExternalResource resource, Provision provision, Any any) {
        ArrayList<String> missingAttrNames = new ArrayList<String>();
        MappingUtils.getPropagationItems(provision.getMapping().getItems().stream()).forEach(item -> {
            AttrSchemaType schemaType;
            MappingManager.IntValues intValues;
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), any.getType().getKind());
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}', ignoring", (Object)item.getIntAttrName(), (Object)e);
            }
            if (intAttrName != null && intAttrName.getSchema() != null && (intValues = this.mappingManager.getIntValues(resource, provision, item, intAttrName, schemaType = intAttrName.getSchema() instanceof PlainSchema ? intAttrName.getSchema().getType() : AttrSchemaType.String, any, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT)).values().isEmpty() && this.jexlTools.evaluateMandatoryCondition(item.getMandatoryCondition(), (Attributable)any, this.derAttrHandler)) {
                missingAttrNames.add(item.getIntAttrName());
            }
        });
        return missingAttrNames;
    }

    protected SyncopeClientException checkMandatoryOnResources(Any any, Collection<? extends ExternalResource> resources) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        resources.stream().filter(ExternalResource::isEnforceMandatoryCondition).forEach(resource -> resource.getProvisionByAnyType(any.getType().getKey()).ifPresent(provision -> {
            List<String> missingAttrNames = this.evaluateMandatoryCondition((ExternalResource)resource, (Provision)provision, any);
            if (!missingAttrNames.isEmpty()) {
                LOG.error("Mandatory schemas {} not provided with values", missingAttrNames);
                reqValMissing.getElements().addAll(missingAttrNames);
            }
        }));
        return reqValMissing;
    }

    protected SyncopeClientException checkMandatory(Any any, AnyUtils anyUtils) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        AllowedSchemas allowedPlainSchemas = anyUtils.dao().findAllowedSchemas(any, PlainSchema.class);
        allowedPlainSchemas.getForSelf().forEach(schema -> this.checkMandatory((PlainSchema)schema, any.getPlainAttr(schema.getKey()).orElse(null), (Attributable)any, reqValMissing));
        if (any instanceof Groupable) {
            Groupable groupable = (Groupable)any;
            allowedPlainSchemas.getForMemberships().forEach((group, schemas) -> {
                Membership membership = groupable.getMembership(group.getKey()).orElse(null);
                schemas.forEach(schema -> this.checkMandatory((PlainSchema)schema, groupable.getPlainAttr(schema.getKey(), membership).orElse(null), (Attributable)any, reqValMissing));
            });
        }
        return reqValMissing;
    }

    protected void processAttrPatch(AnyTO anyTO, Any any, AttrPatch patch, PlainSchema schema, PlainAttr attr, SyncopeClientException invalidValues) {
        switch (patch.getOperation()) {
            case ADD_REPLACE: {
                List valuesToBeAdded;
                if (schema.isUniqueConstraint()) {
                    if (attr.getUniqueValue() != null && !patch.getAttr().getValues().isEmpty() && !((String)patch.getAttr().getValues().getFirst()).equals(attr.getUniqueValue().getValueAsString())) {
                        attr.setUniqueValue(null);
                    }
                } else {
                    attr.getValues().clear();
                }
                if (!((valuesToBeAdded = patch.getAttr().getValues()).isEmpty() || schema.isUniqueConstraint() && attr.getUniqueValue() != null && ((String)valuesToBeAdded.getFirst()).equals(attr.getUniqueValue().getValueAsString()))) {
                    this.fillAttr((AttributableTO)anyTO, valuesToBeAdded, schema, attr, invalidValues);
                }
                if (!attr.getValuesAsStrings().isEmpty()) break;
                any.remove(attr);
                break;
            }
            default: {
                any.remove(attr);
            }
        }
    }

    protected void fill(AnyTO anyTO, Any any, AnyUR anyUR, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException reqValMissing;
        for (StringPatchItem patch2 : anyUR.getAuxClasses()) {
            this.anyTypeClassDAO.findById((String)patch2.getValue()).ifPresentOrElse(auxClass -> {
                switch (patch2.getOperation()) {
                    case ADD_REPLACE: {
                        any.add(auxClass);
                        break;
                    }
                    default: {
                        any.getAuxClasses().remove(auxClass);
                    }
                }
            }, () -> LOG.debug("Invalid {} {}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), patch2.getValue()));
        }
        for (StringPatchItem patch2 : anyUR.getResources()) {
            this.resourceDAO.findById((String)patch2.getValue()).ifPresentOrElse(resource -> {
                switch (patch2.getOperation()) {
                    case ADD_REPLACE: {
                        any.add(resource);
                        break;
                    }
                    default: {
                        any.getResources().remove(resource);
                    }
                }
            }, () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), patch2.getValue()));
        }
        Set resources = anyUtils.getAllResources(any);
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        anyUR.getPlainAttrs().stream().filter(patch -> patch.getAttr() != null).forEach(patch -> this.getPlainSchema(patch.getAttr().getSchema()).ifPresentOrElse(schema -> {
            PlainAttr attr = any.getPlainAttr(schema.getKey()).orElse(null);
            if (attr == null) {
                LOG.debug("No plain attribute found for schema {}", schema);
                if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                    attr = new PlainAttr();
                    attr.setPlainSchema(schema);
                    any.add(attr);
                }
            }
            if (attr != null) {
                this.processAttrPatch(anyTO, any, (AttrPatch)patch, (PlainSchema)schema, attr, invalidValues);
            }
        }, () -> LOG.debug("Invalid {} {}, ignoring...", (Object)PlainSchema.class.getSimpleName(), (Object)patch.getAttr().getSchema())));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(reqValMissing = this.checkMandatory(any, anyUtils)).isEmpty()) {
            scce.addException(reqValMissing);
        }
        if (!(reqValMissing = this.checkMandatoryOnResources(any, resources)).isEmpty()) {
            scce.addException(reqValMissing);
        }
        HashSet<Pair> relationships = new HashSet<Pair>();
        for (RelationshipUR patch3 : anyUR.getRelationships().stream().filter(patch -> patch.getRelationshipTO() != null).toList()) {
            RelationshipType relationshipType = this.relationshipTypeDAO.findById(patch3.getRelationshipTO().getType()).orElse(null);
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch3.getRelationshipTO().getType());
                continue;
            }
            anyUtils.removeRelationship((Relatable)any, relationshipType, patch3.getRelationshipTO().getOtherEndKey());
            if (patch3.getOperation() != PatchOperation.ADD_REPLACE) continue;
            if (StringUtils.isBlank((CharSequence)patch3.getRelationshipTO().getOtherEndType()) || AnyTypeKind.USER.name().equals(patch3.getRelationshipTO().getOtherEndType()) || AnyTypeKind.GROUP.name().equals(patch3.getRelationshipTO().getOtherEndType())) {
                SyncopeClientException invalidAnyType = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
                invalidAnyType.getElements().add(AnyType.class.getSimpleName() + " not allowed for relationship: " + patch3.getRelationshipTO().getOtherEndType());
                scce.addException(invalidAnyType);
                continue;
            }
            AnyObject otherEnd = this.anyObjectDAO.findById(patch3.getRelationshipTO().getOtherEndKey()).orElse(null);
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid any object {}", (Object)patch3.getRelationshipTO().getOtherEndKey());
                continue;
            }
            if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)patch3.getRelationshipTO().getType()))) {
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                assigned.getElements().add("Group was already in relationship " + patch3.getRelationshipTO().getType() + " with " + otherEnd.getType().getKey() + " " + otherEnd.getName());
                scce.addException(assigned);
                continue;
            }
            if (patch3.getRelationshipTO().getEnd() == RelationshipTO.End.RIGHT) {
                SyncopeClientException noRight = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                noRight.getElements().add("Relationships shall be created or updated only from their left end");
                scce.addException(noRight);
                continue;
            }
            relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)patch3.getRelationshipTO().getType()));
            anyUtils.addRelationship((Relatable)any, relationshipType, otherEnd);
        }
    }

    protected PropagationByResource<String> propByRes(Map<String, ConnObject> before, Map<String, ConnObject> after) {
        PropagationByResource propByRes = new PropagationByResource();
        after.forEach((resource, connObject) -> {
            if (before.containsKey(resource)) {
                ConnObject beforeObject = (ConnObject)before.get(resource);
                if (!beforeObject.equals(connObject)) {
                    propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)resource));
                    beforeObject.getAttr(Uid.NAME).map(attr -> (String)attr.getValues().getFirst()).ifPresent(value -> propByRes.addOldConnObjectKey(resource, value));
                }
            } else {
                propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)resource));
            }
        });
        propByRes.addAll(ResourceOperation.DELETE, (Collection)before.keySet().stream().filter(resource -> !after.containsKey(resource)).collect(Collectors.toSet()));
        return propByRes;
    }

    protected void fill(AnyTO anyTO, Any any, AnyCR anyCR, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException requiredValuesMissing;
        any.getAuxClasses().clear();
        anyCR.getAuxClasses().stream().map(arg_0 -> ((AnyTypeClassDAO)this.anyTypeClassDAO).findById(arg_0)).flatMap(Optional::stream).forEach(auxClass -> {
            if (auxClass == null) {
                LOG.debug("Invalid {} {}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), auxClass);
            } else {
                any.add(auxClass);
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        anyCR.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresent(schema -> {
            PlainAttr attr = any.getPlainAttr(schema.getKey()).orElseGet(() -> {
                PlainAttr newAttr = new PlainAttr();
                newAttr.setPlainSchema(schema);
                return newAttr;
            });
            this.fillAttr((AttributableTO)anyTO, attrTO.getValues(), (PlainSchema)schema, attr, invalidValues);
            if (!attr.getValuesAsStrings().isEmpty()) {
                any.add(attr);
            }
        }));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(requiredValuesMissing = this.checkMandatory(any, anyUtils)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        anyCR.getResources().forEach(resource -> this.resourceDAO.findById(resource).ifPresentOrElse(arg_0 -> ((Any)any).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), resource)));
        requiredValuesMissing = this.checkMandatoryOnResources(any, anyUtils.getAllResources(any));
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        HashSet relationships = new HashSet();
        anyCR.getRelationships().forEach(relationshipTO -> {
            if (StringUtils.isBlank((CharSequence)relationshipTO.getOtherEndType()) || AnyTypeKind.USER.name().equals(relationshipTO.getOtherEndType()) || AnyTypeKind.GROUP.name().equals(relationshipTO.getOtherEndType())) {
                SyncopeClientException invalidAnyType = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
                invalidAnyType.getElements().add(AnyType.class.getSimpleName() + " not allowed for relationship: " + relationshipTO.getOtherEndType());
                scce.addException(invalidAnyType);
            } else {
                AnyObject otherEnd = this.anyObjectDAO.findById(relationshipTO.getOtherEndKey()).orElse(null);
                if (otherEnd == null) {
                    LOG.debug("Ignoring invalid anyObject {}", (Object)relationshipTO.getOtherEndKey());
                } else if (relationshipTO.getEnd() == RelationshipTO.End.RIGHT) {
                    SyncopeClientException noRight = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                    noRight.getElements().add("Relationships shall be created or updated only from their left end");
                    scce.addException(noRight);
                } else if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()))) {
                    SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                    assigned.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " in relationship " + relationshipTO.getType());
                    scce.addException(assigned);
                } else {
                    relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()));
                    this.relationshipTypeDAO.findById(relationshipTO.getType()).ifPresentOrElse(rt -> anyUtils.addRelationship((Relatable)any, rt, otherEnd), () -> LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType()));
                }
            }
        });
    }

    protected void fill(AnyTO anyTO, Any any, Membership<?> membership, MembershipTO membershipTO, SyncopeClientCompositeException scce) {
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        membershipTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresent(schema -> {
            PlainAttr attr = ((Groupable)any).getPlainAttr(schema.getKey(), membership).orElseGet(() -> {
                PlainAttr gpa = new PlainAttr();
                gpa.setMembership(membership.getKey());
                gpa.setPlainSchema(schema);
                return gpa;
            });
            this.fillAttr((AttributableTO)anyTO, attrTO.getValues(), (PlainSchema)schema, attr, invalidValues);
            if (!attr.getValuesAsStrings().isEmpty()) {
                any.add(attr);
            }
        }));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
    }
}

