/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.code;

import com.google.common.base.Splitter;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.expiration.FixedInstantExpirationPolicy;
import org.apereo.cas.ticket.registry.TicketCompactor;
import org.apereo.cas.util.DateTimeUtils;
import org.springframework.beans.factory.ObjectProvider;

public class OAuth20CodeCompactor
implements TicketCompactor<OAuth20Code> {
    private final ObjectProvider<TicketFactory> ticketFactory;
    private final ServiceFactory serviceFactory;
    private final PrincipalFactory principalFactory;
    private long maximumTicketLength = 384L;

    public String compact(StringBuilder builder, Ticket ticket) throws Exception {
        OAuth20Code code = (OAuth20Code)ticket;
        builder.append(String.format("%s%s", ",", code.getService().getShortenedId()));
        builder.append(String.format("%s%s", ",", code.getClientId()));
        builder.append(String.format("%s%s", ",", String.join((CharSequence)"|", code.getScopes())));
        builder.append(String.format("%s%s", ",", StringUtils.defaultString((String)code.getCodeChallenge())));
        builder.append(String.format("%s%s", ",", StringUtils.defaultString((String)code.getCodeChallengeMethod())));
        builder.append(String.format("%s%s", ",", code.getResponseType() != null ? code.getResponseType().ordinal() : OAuth20ResponseTypes.CODE.ordinal()));
        builder.append(String.format("%s%s", ",", code.getGrantType() != null ? code.getGrantType().ordinal() : OAuth20GrantTypes.AUTHORIZATION_CODE.ordinal()));
        builder.append(this.compactAuthenticationAttempt(code).toString());
        return builder.toString();
    }

    public Class<OAuth20Code> getTicketType() {
        return OAuth20Code.class;
    }

    public Ticket expand(String ticketId) throws Throwable {
        TicketCompactor.CompactTicket structure = this.parse(ticketId);
        Service service = this.serviceFactory.createService((String)structure.ticketElements().get(TicketCompactor.CompactTicketIndexes.SERVICE.getIndex()));
        String clientId = (String)structure.ticketElements().get(3);
        HashSet scopes = StringUtils.isNotBlank((CharSequence)((CharSequence)structure.ticketElements().get(4))) ? Splitter.on((String)"|").splitToList((CharSequence)structure.ticketElements().get(4)) : new HashSet();
        String codeChallenge = StringUtils.trimToNull((String)((String)structure.ticketElements().get(5)));
        String codeChallengeMethod = StringUtils.trimToNull((String)((String)structure.ticketElements().get(6)));
        OAuth20ResponseTypes responseType = OAuth20ResponseTypes.values()[Integer.parseInt((String)structure.ticketElements().get(7))];
        OAuth20GrantTypes grantType = OAuth20GrantTypes.values()[Integer.parseInt((String)structure.ticketElements().get(8))];
        Authentication authentication = this.expandAuthentication(this.principalFactory, structure);
        OAuth20CodeFactory codeFactory = (OAuth20CodeFactory)((TicketFactory)this.ticketFactory.getObject()).get(this.getTicketType());
        OAuth20Code code = codeFactory.create(service, authentication, null, scopes, codeChallenge, codeChallengeMethod, clientId, new HashMap(), responseType, grantType);
        code.setExpirationPolicy((ExpirationPolicy)new FixedInstantExpirationPolicy(structure.expirationTime()));
        code.setCreationTime(DateTimeUtils.zonedDateTimeOf((Instant)structure.creationTime()));
        return code;
    }

    protected Authentication expandAuthentication(PrincipalFactory principalFactory, TicketCompactor.CompactTicket structure) throws Throwable {
        List authenticationData = Splitter.on((String)":").splitToList((CharSequence)structure.ticketElements().get(9));
        Principal principal = principalFactory.createPrincipal((String)authenticationData.getFirst());
        Set handlers = Arrays.stream(((String)authenticationData.get(1)).split("#")).collect(Collectors.toSet());
        Set credentialTypes = Arrays.stream(((String)authenticationData.get(2)).split("#")).collect(Collectors.toSet());
        return DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).addAttribute("credentialType", credentialTypes).addAttribute("successfulAuthenticationHandlers", handlers).setSuccesses(handlers.stream().collect(Collectors.toMap(Function.identity(), name -> new DefaultAuthenticationHandlerExecutionResult(name, principal)))).addAttribute("authenticationMethod", handlers).build();
    }

    protected StringBuilder compactAuthenticationAttempt(OAuth20Code code) {
        Authentication authentication = code.getAuthentication();
        StringBuilder builder = new StringBuilder();
        if (authentication != null) {
            String handlers = String.join((CharSequence)"#", authentication.getSuccesses().keySet());
            String principalId = authentication.getPrincipal().getId();
            String credentialTypes = authentication.getCredentials().stream().map(credential -> credential.getClass().getSimpleName()).collect(Collectors.joining("#"));
            builder.append(String.format("%s%s:%s:%s", ",", principalId, handlers, credentialTypes));
        }
        return builder;
    }

    @Generated
    public OAuth20CodeCompactor(ObjectProvider<TicketFactory> ticketFactory, ServiceFactory serviceFactory, PrincipalFactory principalFactory) {
        this.ticketFactory = ticketFactory;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
    }

    @Generated
    public long getMaximumTicketLength() {
        return this.maximumTicketLength;
    }
}

