/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Delegation;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.DelegationCheck;

public class DelegationValidator
extends AbstractValidator<DelegationCheck, Delegation> {
    public boolean isValid(Delegation delegation, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (delegation.getDelegating().equals((Object)delegation.getDelegated())) {
            context.buildConstraintViolationWithTemplate(DelegationValidator.getTemplate(EntityViolationType.Standard, "delegating must be different from delegated")).addPropertyNode("delegating").addConstraintViolation();
            isValid = false;
        }
        if (isValid && delegation.getEnd() != null && !delegation.getEnd().isAfter(delegation.getStart())) {
            context.buildConstraintViolationWithTemplate(DelegationValidator.getTemplate(EntityViolationType.Standard, "when end is provided it must to be after start")).addPropertyNode("end").addConstraintViolation();
            isValid = false;
        }
        if (isValid && !delegation.getDelegating().getRoles().containsAll(delegation.getRoles())) {
            context.buildConstraintViolationWithTemplate(DelegationValidator.getTemplate(EntityViolationType.Standard, "only Roles assigned to delegating User can be granted")).addPropertyNode("roles").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }
}

