/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.el;

import jakarta.el.BeanELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import java.beans.FeatureDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.binding.expression.el.DefaultELContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class ImplicitFlowVariableELResolver
extends ELResolver {
    private RequestContext requestContext;

    public ImplicitFlowVariableELResolver() {
    }

    public ImplicitFlowVariableELResolver(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return Object.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return null;
        }
        if (ImplicitVariables.matches(property)) {
            context.setPropertyResolved(true);
            return ImplicitVariables.value(context, requestContext, property).getClass();
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return null;
        }
        if (ImplicitVariables.matches(property)) {
            context.setPropertyResolved(true);
            return ImplicitVariables.value(context, requestContext, property);
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return false;
        }
        if (ImplicitVariables.matches(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return;
        }
        if (ImplicitVariables.matches(property)) {
            context.setPropertyResolved(true);
            throw new PropertyNotWritableException("The implicit flow variable " + property + " is not writable.");
        }
    }

    protected RequestContext getRequestContext() {
        return this.requestContext != null ? this.requestContext : RequestContextHolder.getRequestContext();
    }

    private static final class ImplicitVariables {
        private static final Map<String, PropertyResolver> vars = new HashMap<String, PropertyResolver>();
        private static final PropertyResolver requestContextResolver = new PropertyResolver(){

            @Override
            protected Object doResolve(ELContext elContext, RequestContext requestContext, Object property) {
                return elContext.getELResolver().getValue(elContext, (Object)requestContext, property);
            }
        };
        private static final PropertyResolver externalContextResolver = new PropertyResolver(){

            @Override
            protected Object doResolve(ELContext elContext, RequestContext requestContext, Object property) {
                return elContext.getELResolver().getValue(elContext, (Object)requestContext.getExternalContext(), property);
            }
        };
        private static final PropertyResolver currentEventResolver = new PropertyResolver(){

            @Override
            protected Object doResolve(ELContext elContext, RequestContext requestContext, Object property) {
                return requestContext.getCurrentEvent();
            }
        };

        private ImplicitVariables() {
        }

        public static boolean matches(Object property) {
            return vars.containsKey(property);
        }

        public static Object value(ELContext elContext, RequestContext requestContext, Object property) {
            PropertyResolver resolver = vars.get(property);
            return resolver.resolve(requestContext, property);
        }

        static {
            vars.put("requestParameters", requestContextResolver);
            vars.put("requestScope", requestContextResolver);
            vars.put("flashScope", requestContextResolver);
            vars.put("viewScope", requestContextResolver);
            vars.put("flowScope", requestContextResolver);
            vars.put("conversationScope", requestContextResolver);
            vars.put("messageContext", requestContextResolver);
            vars.put("externalContext", requestContextResolver);
            vars.put("flowExecutionContext", requestContextResolver);
            vars.put("flowExecutionUrl", requestContextResolver);
            vars.put("currentUser", externalContextResolver);
            vars.put("currentEvent", currentEventResolver);
        }
    }

    private static abstract class PropertyResolver {
        private static final BeanELResolver elPropertyResolver = new BeanELResolver();

        private PropertyResolver() {
        }

        public Object resolve(RequestContext context, Object property) {
            DefaultELContext elContext = new DefaultELContext((ELResolver)elPropertyResolver, null, null);
            return this.doResolve((ELContext)elContext, context, property);
        }

        protected abstract Object doResolve(ELContext var1, RequestContext var2, Object var3);
    }
}

