/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.KotlinDetector;
import org.springframework.integration.handler.support.CollectionArgumentResolver;
import org.springframework.integration.handler.support.ContinuationHandlerMethodArgumentResolver;
import org.springframework.integration.handler.support.IntegrationInvocableHandlerMethod;
import org.springframework.integration.handler.support.MapArgumentResolver;
import org.springframework.integration.handler.support.PayloadExpressionArgumentResolver;
import org.springframework.integration.handler.support.PayloadsArgumentResolver;
import org.springframework.integration.support.NullAwarePayloadArgumentResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class IntegrationMessageHandlerMethodFactory
extends DefaultMessageHandlerMethodFactory {
    private final HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private final boolean listCapable;
    private MessageConverter messageConverter;
    private BeanFactory beanFactory;

    public IntegrationMessageHandlerMethodFactory() {
        this(false);
    }

    public IntegrationMessageHandlerMethodFactory(boolean listCapable) {
        this.listCapable = listCapable;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        super.setMessageConverter(messageConverter);
        this.messageConverter = messageConverter;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        this.setCustomArgumentResolvers(this.buildArgumentResolvers(this.listCapable));
        super.afterPropertiesSet();
    }

    protected List<HandlerMethodArgumentResolver> initArgumentResolvers() {
        List resolvers = super.initArgumentResolvers();
        this.argumentResolvers.addResolvers(resolvers);
        return resolvers;
    }

    public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
        IntegrationInvocableHandlerMethod handlerMethod = new IntegrationInvocableHandlerMethod(bean, method);
        handlerMethod.setMessageMethodArgumentResolvers(this.argumentResolvers);
        return handlerMethod;
    }

    private List<HandlerMethodArgumentResolver> buildArgumentResolvers(boolean listCapable) {
        ArrayList<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
        resolvers.add(new PayloadExpressionArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new NullAwarePayloadArgumentResolver(this.messageConverter));
        resolvers.add(new PayloadsArgumentResolver());
        if (listCapable) {
            resolvers.add(new CollectionArgumentResolver(true));
        }
        resolvers.add(new MapArgumentResolver());
        if (KotlinDetector.isKotlinPresent()) {
            resolvers.add(new ContinuationHandlerMethodArgumentResolver());
        }
        for (HandlerMethodArgumentResolver resolver : resolvers) {
            if (resolver instanceof BeanFactoryAware) {
                ((BeanFactoryAware)resolver).setBeanFactory(this.beanFactory);
            }
            if (!(resolver instanceof InitializingBean)) continue;
            try {
                ((InitializingBean)resolver).afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Cannot initialize 'HandlerMethodArgumentResolver'", (Throwable)ex);
            }
        }
        return resolvers;
    }
}

