/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005]4Aa\u0005\u000b\u00013!)\u0001\u0005\u0001C\u0001C!IA\u0005\u0001a\u0001\u0002\u0004%\t!\n\u0005\ni\u0001\u0001\r\u00111A\u0005\u0002UB\u0011b\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0014\t\u000fq\u0002!\u0019!C\u0001{!1\u0011\t\u0001Q\u0001\nyBqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004H\u0001\u0001\u0006I\u0001\u0012\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006+\u0002!\t!\u0013\u0005\u00065\u0002!\t!\u0013\u0005\u0006?\u0002!\t!\u0013\u0005\u0006C\u0002!\t!\u0013\u0005\u0006G\u0002!\t!\u0013\u0005\u0006K\u0002!\t!\u0013\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006k\u0002!\t!\u0013\u0002\u000e)&lW-\u00138eKb$Vm\u001d;\u000b\u0005U1\u0012a\u00017pO*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u0005\u0019\u0011\u000e\u001a=\u0016\u0003\u0019\u0002\"a\n\u001a\u000e\u0003!R!!F\u0015\u000b\u0005)Z\u0013!C5oi\u0016\u0014h.\u00197t\u0015\taS&A\u0004ti>\u0014\u0018mZ3\u000b\u0005]q#BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001eL!a\r\u0015\u0003\u0013QKW.Z%oI\u0016D\u0018aB5eq~#S-\u001d\u000b\u0003me\u0002\"aG\u001c\n\u0005ab\"\u0001B+oSRDqAO\u0002\u0002\u0002\u0003\u0007a%A\u0002yIE\nA!\u001b3yA\u0005QQ.\u0019=F]R\u0014\u0018.Z:\u0016\u0003y\u0002\"aG \n\u0005\u0001c\"aA%oi\u0006YQ.\u0019=F]R\u0014\u0018.Z:!\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0002\tB\u00111$R\u0005\u0003\rr\u0011A\u0001T8oO\u0006Y!-Y:f\u001f\u001a47/\u001a;!\u0003\u0015\u0019X\r^;q)\u00051\u0004FA\u0005L!\ta5+D\u0001N\u0015\tqu*A\u0002ba&T!\u0001U)\u0002\u000f),\b/\u001b;fe*\u0011!\u000bM\u0001\u0006UVt\u0017\u000e^\u0005\u0003)6\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007F\u0001\u0006X!\ta\u0005,\u0003\u0002Z\u001b\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u000bi\u0016\u001cH\u000fT8pWV\u0003\bFA\u0006]!\taU,\u0003\u0002_\u001b\n!A+Z:u\u0003%!Xm\u001d;F]R\u0014\u0018\u0010\u000b\u0002\r9\u0006\tB/Z:u\u000b:$(/_(wKJ4Gn\\<)\u00055a\u0016\u0001\u0004;fgR$&/\u001e8dCR,\u0007F\u0001\b]\u0003)!Xm\u001d;BaB,g\u000e\u001a\u0015\u0003\u001fq\u000bQ\"\u00199qK:$WI\u001c;sS\u0016\u001cHC\u0001\u001cj\u0011\u0015Q\u0007\u00031\u0001?\u0003)qW/\\#oiJLWm]\u0001\u0014]>tW\t_5ti\u0016tG\u000fV3na\u001aKG.\u001a\u000b\u0002[B\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0003S>T\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n!a)\u001b7f\u0003=!Xm\u001d;TC:LG/_\"iK\u000e\\\u0007F\u0001\n]\u0001")
public class TimeIndexTest {
    private TimeIndex idx;
    private final int maxEntries;
    private final long baseOffset;

    public TimeIndex idx() {
        return this.idx;
    }

    public void idx_$eq(TimeIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @BeforeEach
    public void setup() {
        this.idx_$eq(new TimeIndex(this.nonExistentTempFile(), this.baseOffset(), this.maxEntries() * 12));
    }

    @AfterEach
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
            return;
        }
    }

    @Test
    public void testLookUp() {
        Assertions.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(100L));
        this.appendEntries(this.maxEntries() - 1);
        Assertions.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(9L));
        Assertions.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().lookup(25L));
        Assertions.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().lookup(30L));
    }

    @Test
    public void testEntry() {
        this.appendEntries(this.maxEntries() - 1);
        Assertions.assertEquals((Object)new TimestampOffset(10L, 55L), (Object)this.idx().entry(0));
        Assertions.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().entry(1));
        Assertions.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().entry(2));
        Assertions.assertEquals((Object)new TimestampOffset(40L, 85L), (Object)this.idx().entry(3));
    }

    @Test
    public void testEntryOverflow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().entry(0));
    }

    @Test
    public void testTruncate() {
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncate();
        Assertions.assertEquals((int)0, (int)this.idx().entries());
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncateTo(10L + this.baseOffset());
        Assertions.assertEquals((int)0, (int)this.idx().entries());
    }

    @Test
    public void testAppend() {
        this.appendEntries(this.maxEntries() - 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().maybeAppend(10000L, 1000L));
        Assertions.assertThrows(InvalidOffsetException.class, () -> this.idx().maybeAppend(10000L, (long)((this.maxEntries() - 2) * 10), true));
        this.idx().maybeAppend(10000L, 1000L, true);
    }

    private void appendEntries(int numEntries) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numEntries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.idx().maybeAppend((long)(i * 10), (long)(i * 10) + this.baseOffset()));
    }

    public File nonExistentTempFile() {
        File file = TestUtils.tempFile((String)"kafka", (String)".tmp");
        file.delete();
        return file;
    }

    @Test
    public void testSanityCheck() {
        this.idx().sanityCheck();
        this.appendEntries(5);
        TimestampOffset firstEntry = this.idx().entry(0);
        this.idx().sanityCheck();
        this.idx().close();
        BooleanRef shouldCorruptOffset = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptTimestamp = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptLength = BooleanRef.create((boolean)false);
        this.idx_$eq(new TimeIndex(this, shouldCorruptOffset, shouldCorruptTimestamp, firstEntry, shouldCorruptLength){
            private final BooleanRef shouldCorruptOffset$1;
            private final BooleanRef shouldCorruptTimestamp$1;
            private final TimestampOffset firstEntry$1;
            private final BooleanRef shouldCorruptLength$1;

            public TimestampOffset lastEntry() {
                TimestampOffset superLastEntry = super.lastEntry();
                long offset = this.shouldCorruptOffset$1.elem ? this.baseOffset() - 1L : superLastEntry.offset;
                long timestamp = this.shouldCorruptTimestamp$1.elem ? this.firstEntry$1.timestamp - 1L : superLastEntry.timestamp;
                return new TimestampOffset(timestamp, offset);
            }

            public long length() {
                long superLength = super.length();
                if (this.shouldCorruptLength$1.elem) {
                    return superLength - 1L;
                }
                return superLength;
            }
            {
                this.shouldCorruptOffset$1 = shouldCorruptOffset$1;
                this.shouldCorruptTimestamp$1 = shouldCorruptTimestamp$1;
                this.firstEntry$1 = firstEntry$1;
                this.shouldCorruptLength$1 = shouldCorruptLength$1;
                super($outer.idx().file(), $outer.baseOffset(), $outer.maxEntries() * 12);
            }
        });
        shouldCorruptOffset.elem = true;
        Assertions.assertThrows(CorruptIndexException.class, () -> this.idx().sanityCheck());
        shouldCorruptOffset.elem = false;
        shouldCorruptTimestamp.elem = true;
        Assertions.assertThrows(CorruptIndexException.class, () -> this.idx().sanityCheck());
        shouldCorruptTimestamp.elem = false;
        shouldCorruptLength.elem = true;
        Assertions.assertThrows(CorruptIndexException.class, () -> this.idx().sanityCheck());
        shouldCorruptLength.elem = false;
        this.idx().sanityCheck();
        this.idx().close();
    }

    public TimeIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

