/*
 * Decompiled with CFR 0.152.
 */
package kafka.test.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.server.ControllerServer;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeFeaturesResult;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumResult;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.MismatchedEndpointTypeException;
import org.apache.kafka.common.errors.UnsupportedEndpointTypeException;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=120L)
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class BootstrapControllersIntegrationTest {
    private KafkaClusterTestKit cluster;
    private String bootstrapControllerString;

    @BeforeAll
    public void createCluster() throws Exception {
        this.cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();
        this.cluster.format();
        this.cluster.startup();
        this.cluster.waitForActiveController();
        this.cluster.waitForReadyBrokers();
        StringBuilder bootstrapControllerStringBuilder = new StringBuilder();
        String prefix = "";
        for (ControllerServer controller : this.cluster.controllers().values()) {
            bootstrapControllerStringBuilder.append(prefix);
            prefix = ",";
            int port = (Integer)controller.socketServerFirstBoundPortFuture().get(1L, TimeUnit.MINUTES);
            bootstrapControllerStringBuilder.append("localhost:").append(port);
        }
        this.bootstrapControllerString = bootstrapControllerStringBuilder.toString();
    }

    @AfterAll
    public void destroyCluster() throws Exception {
        this.cluster.close();
    }

    private Properties adminProperties(boolean usingBootstrapControllers) {
        Properties properties = this.cluster.clientProperties();
        if (usingBootstrapControllers) {
            properties.remove("bootstrap.servers");
            properties.setProperty("bootstrap.controllers", this.bootstrapControllerString);
        }
        return properties;
    }

    @Test
    public void testPutBrokersInBootstrapControllersConfig() {
        Properties properties = this.cluster.clientProperties();
        properties.put("bootstrap.controllers", properties.getProperty("bootstrap.servers"));
        properties.remove("bootstrap.servers");
        try (Admin admin = Admin.create((Properties)properties);){
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
                String cfr_ignored_0 = (String)admin.describeCluster().clusterId().get(1L, TimeUnit.MINUTES);
            });
            Assertions.assertNotNull((Object)exception.getCause());
            Assertions.assertEquals(MismatchedEndpointTypeException.class, exception.getCause().getClass());
            Assertions.assertEquals((Object)"The request was sent to an endpoint of type BROKER, but we wanted an endpoint of type CONTROLLER", (Object)exception.getCause().getMessage());
        }
    }

    @Disabled
    @Test
    public void testPutControllersInBootstrapBrokersConfig() {
        Properties properties = this.cluster.clientProperties();
        properties.put("bootstrap.servers", this.bootstrapControllerString);
        try (Admin admin = Admin.create((Properties)properties);){
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
                String cfr_ignored_0 = (String)admin.describeCluster().clusterId().get(1L, TimeUnit.MINUTES);
            });
            Assertions.assertNotNull((Object)exception.getCause());
            Assertions.assertEquals(MismatchedEndpointTypeException.class, exception.getCause().getClass());
            Assertions.assertEquals((Object)"This endpoint does not appear to be a BROKER.", (Object)exception.getCause().getMessage());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testDescribeCluster(boolean usingBootstrapControllers) throws Exception {
        try (Admin admin = Admin.create((Properties)this.adminProperties(usingBootstrapControllers));){
            DescribeClusterResult result = admin.describeCluster();
            Assertions.assertEquals((Object)this.cluster.controllers().values().iterator().next().clusterId(), (Object)result.clusterId().get(1L, TimeUnit.MINUTES));
            if (usingBootstrapControllers) {
                Assertions.assertEquals((int)((QuorumController)this.cluster.waitForActiveController()).nodeId(), (int)((Node)result.controller().get()).id());
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testDescribeFeatures(boolean usingBootstrapControllers) throws Exception {
        try (Admin admin = Admin.create((Properties)this.adminProperties(usingBootstrapControllers));){
            DescribeFeaturesResult result = admin.describeFeatures();
            short metadataVersion = this.cluster.controllers().values().iterator().next().featuresPublisher().features().metadataVersion().featureLevel();
            Assertions.assertEquals((Object)new FinalizedVersionRange(metadataVersion, metadataVersion), ((FeatureMetadata)result.featureMetadata().get(1L, TimeUnit.MINUTES)).finalizedFeatures().get("metadata.version"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testUpdateFeatures(boolean usingBootstrapControllers) {
        try (Admin admin = Admin.create((Properties)this.adminProperties(usingBootstrapControllers));){
            UpdateFeaturesResult result = admin.updateFeatures(Collections.singletonMap("foo.bar.feature", new FeatureUpdate(1, FeatureUpdate.UpgradeType.UPGRADE)), new UpdateFeaturesOptions());
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
                Void cfr_ignored_0 = (Void)result.all().get(1L, TimeUnit.MINUTES);
            });
            Assertions.assertNotNull((Object)exception.getCause());
            Assertions.assertEquals(InvalidUpdateVersionException.class, exception.getCause().getClass());
            Assertions.assertTrue((boolean)exception.getCause().getMessage().endsWith("does not support this feature."), (String)("expected message to end with 'does not support this feature', but it was: " + exception.getCause().getMessage()));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testDescribeMetadataQuorum(boolean usingBootstrapControllers) throws Exception {
        try (Admin admin = Admin.create((Properties)this.adminProperties(usingBootstrapControllers));){
            DescribeMetadataQuorumResult result = admin.describeMetadataQuorum();
            Assertions.assertEquals((int)((QuorumController)this.cluster.waitForActiveController()).nodeId(), (int)((QuorumInfo)result.quorumInfo().get(1L, TimeUnit.MINUTES)).leaderId());
        }
    }

    @Test
    public void testUsingBootstrapControllersOnUnsupportedAdminApi() {
        try (Admin admin = Admin.create((Properties)this.adminProperties(true));){
            ListOffsetsResult result = admin.listOffsets(Collections.singletonMap(new TopicPartition("foo", 0), OffsetSpec.earliest()));
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
                Map cfr_ignored_0 = (Map)result.all().get(1L, TimeUnit.MINUTES);
            });
            Assertions.assertNotNull((Object)exception.getCause());
            Assertions.assertEquals(UnsupportedEndpointTypeException.class, exception.getCause().getClass());
            Assertions.assertEquals((Object)"This Admin API is not yet supported when communicating directly with the controller quorum.", (Object)exception.getCause().getMessage());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testIncrementalAlterConfigs(boolean usingBootstrapControllers) throws Exception {
        try (Admin admin = Admin.create((Properties)this.adminProperties(usingBootstrapControllers));){
            int nodeId = usingBootstrapControllers ? this.cluster.controllers().values().iterator().next().config().nodeId() : this.cluster.brokers().values().iterator().next().config().nodeId();
            ConfigResource nodeResource = new ConfigResource(ConfigResource.Type.BROKER, "" + nodeId);
            ConfigResource defaultResource = new ConfigResource(ConfigResource.Type.BROKER, "");
            HashMap<ConfigResource, List<AlterConfigOp>> alterations = new HashMap<ConfigResource, List<AlterConfigOp>>();
            alterations.put(nodeResource, Arrays.asList(new AlterConfigOp(new ConfigEntry("my.custom.config", "foo"), AlterConfigOp.OpType.SET)));
            alterations.put(defaultResource, Arrays.asList(new AlterConfigOp(new ConfigEntry("my.custom.config", "bar"), AlterConfigOp.OpType.SET)));
            admin.incrementalAlterConfigs(alterations).all().get(1L, TimeUnit.MINUTES);
            TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> {
                Config config = (Config)((Map)admin.describeConfigs(Arrays.asList(nodeResource)).all().get(1L, TimeUnit.MINUTES)).get(nodeResource);
                ConfigEntry entry = config.entries().stream().filter(e -> e.name().equals("my.custom.config")).findFirst().get();
                Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG, (Object)entry.source(), (String)("Expected entry for my.custom.config to come from DYNAMIC_BROKER_CONFIG. Instead, the entry was: " + entry));
            });
        }
    }
}

