/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public final class ControllerMetadataMetrics
implements AutoCloseable {
    private static final MetricName FENCED_BROKER_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "FencedBrokerCount");
    private static final MetricName ACTIVE_BROKER_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "ActiveBrokerCount");
    private static final MetricName MIGRATING_ZK_BROKER_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "MigratingZkBrokerCount");
    private static final MetricName GLOBAL_TOPIC_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "GlobalTopicCount");
    private static final MetricName GLOBAL_PARTITION_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "GlobalPartitionCount");
    private static final MetricName OFFLINE_PARTITION_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "OfflinePartitionsCount");
    private static final MetricName PREFERRED_REPLICA_IMBALANCE_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "PreferredReplicaImbalanceCount");
    private static final MetricName METADATA_ERROR_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "MetadataErrorCount");
    private static final MetricName ZK_MIGRATION_STATE = ControllerMetadataMetrics.getMetricName("KafkaController", "ZkMigrationState");
    private final Optional<MetricsRegistry> registry;
    private final AtomicInteger fencedBrokerCount = new AtomicInteger(0);
    private final AtomicInteger activeBrokerCount = new AtomicInteger(0);
    private final AtomicInteger migratingZkBrokerCount = new AtomicInteger(0);
    private final AtomicInteger globalTopicCount = new AtomicInteger(0);
    private final AtomicInteger globalPartitionCount = new AtomicInteger(0);
    private final AtomicInteger offlinePartitionCount = new AtomicInteger(0);
    private final AtomicInteger preferredReplicaImbalanceCount = new AtomicInteger(0);
    private final AtomicInteger metadataErrorCount = new AtomicInteger(0);
    private final AtomicInteger zkMigrationState = new AtomicInteger(-1);

    public ControllerMetadataMetrics(Optional<MetricsRegistry> registry) {
        this.registry = registry;
        registry.ifPresent(r -> r.newGauge(FENCED_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.fencedBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(ACTIVE_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.activeBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_TOPIC_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.globalTopicCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(GLOBAL_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.globalPartitionCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(OFFLINE_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.offlinePartitionCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(PREFERRED_REPLICA_IMBALANCE_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.preferredReplicaImbalanceCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(METADATA_ERROR_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.metadataErrorCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(ZK_MIGRATION_STATE, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.zkMigrationState();
            }
        }));
        registry.ifPresent(r -> r.newGauge(MIGRATING_ZK_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.migratingZkBrokerCount();
            }
        }));
    }

    public void setFencedBrokerCount(int brokerCount) {
        this.fencedBrokerCount.set(brokerCount);
    }

    public void addToFencedBrokerCount(int brokerCountDelta) {
        this.fencedBrokerCount.addAndGet(brokerCountDelta);
    }

    public int fencedBrokerCount() {
        return this.fencedBrokerCount.get();
    }

    public void setActiveBrokerCount(int brokerCount) {
        this.activeBrokerCount.set(brokerCount);
    }

    public void addToActiveBrokerCount(int brokerCountDelta) {
        this.activeBrokerCount.addAndGet(brokerCountDelta);
    }

    public int activeBrokerCount() {
        return this.activeBrokerCount.get();
    }

    public void setMigratingZkBrokerCount(int brokerCount) {
        this.migratingZkBrokerCount.set(brokerCount);
    }

    public void addToMigratingZkBrokerCount(int brokerCountDelta) {
        this.migratingZkBrokerCount.addAndGet(brokerCountDelta);
    }

    public int migratingZkBrokerCount() {
        return this.migratingZkBrokerCount.get();
    }

    public void setGlobalTopicCount(int topicCount) {
        this.globalTopicCount.set(topicCount);
    }

    public void addToGlobalTopicCount(int topicCountDelta) {
        this.globalTopicCount.addAndGet(topicCountDelta);
    }

    public int globalTopicCount() {
        return this.globalTopicCount.get();
    }

    public void setGlobalPartitionCount(int partitionCount) {
        this.globalPartitionCount.set(partitionCount);
    }

    public void addToGlobalPartitionCount(int partitionCountDelta) {
        this.globalPartitionCount.addAndGet(partitionCountDelta);
    }

    public int globalPartitionCount() {
        return this.globalPartitionCount.get();
    }

    public void setOfflinePartitionCount(int offlinePartitions) {
        this.offlinePartitionCount.set(offlinePartitions);
    }

    public void addToOfflinePartitionCount(int offlinePartitionsDelta) {
        this.offlinePartitionCount.addAndGet(offlinePartitionsDelta);
    }

    public int offlinePartitionCount() {
        return this.offlinePartitionCount.get();
    }

    public void setPreferredReplicaImbalanceCount(int replicaImbalances) {
        this.preferredReplicaImbalanceCount.set(replicaImbalances);
    }

    public void addToPreferredReplicaImbalanceCount(int replicaImbalancesCount) {
        this.preferredReplicaImbalanceCount.addAndGet(replicaImbalancesCount);
    }

    public int preferredReplicaImbalanceCount() {
        return this.preferredReplicaImbalanceCount.get();
    }

    public void incrementMetadataErrorCount() {
        this.metadataErrorCount.getAndIncrement();
    }

    public int metadataErrorCount() {
        return this.metadataErrorCount.get();
    }

    public void setZkMigrationState(byte migrationStateValue) {
        this.zkMigrationState.set(migrationStateValue);
    }

    public byte zkMigrationState() {
        return this.zkMigrationState.byteValue();
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> Arrays.asList(FENCED_BROKER_COUNT, ACTIVE_BROKER_COUNT, MIGRATING_ZK_BROKER_COUNT, GLOBAL_TOPIC_COUNT, GLOBAL_PARTITION_COUNT, OFFLINE_PARTITION_COUNT, PREFERRED_REPLICA_IMBALANCE_COUNT, METADATA_ERROR_COUNT, ZK_MIGRATION_STATE).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }
}

